/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;

public class ClusterAlertsUtil {
    private static final String WATCH_FILE = "/monitoring/watches/%s.json";
    private static final Pattern CLUSTER_UUID_PROPERTY = Pattern.compile(Pattern.quote("${monitoring.watch.cluster_uuid}"));
    private static final Pattern WATCH_ID_PROPERTY = Pattern.compile(Pattern.quote("${monitoring.watch.id}"));
    private static final Pattern UNIQUE_WATCH_ID_PROPERTY = Pattern.compile(Pattern.quote("${monitoring.watch.unique_id}"));
    public static final int LAST_UPDATED_VERSION = Version.V_7_0_0.id;
    public static final String[] WATCH_IDS = new String[]{"elasticsearch_cluster_status", "elasticsearch_version_mismatch", "kibana_version_mismatch", "logstash_version_mismatch", "xpack_license_expiration", "elasticsearch_nodes"};

    public static String createUniqueWatchId(ClusterService clusterService, String watchId) {
        return ClusterAlertsUtil.createUniqueWatchId(clusterService.state().metaData().clusterUUID(), watchId);
    }

    private static String createUniqueWatchId(String clusterUuid, String watchId) {
        return clusterUuid + "_" + watchId;
    }

    public static String loadWatch(ClusterService clusterService, String watchId) {
        String resource = String.format(Locale.ROOT, WATCH_FILE, watchId);
        try {
            String clusterUuid = clusterService.state().metaData().clusterUUID();
            String uniqueWatchId = ClusterAlertsUtil.createUniqueWatchId(clusterUuid, watchId);
            String source = ClusterAlertsUtil.loadResource(resource).utf8ToString();
            source = CLUSTER_UUID_PROPERTY.matcher(source).replaceAll(clusterUuid);
            source = WATCH_ID_PROPERTY.matcher(source).replaceAll(watchId);
            source = UNIQUE_WATCH_ID_PROPERTY.matcher(source).replaceAll(uniqueWatchId);
            return source;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load Watch [" + watchId + "]", e);
        }
    }

    private static BytesReference loadResource(String resource) throws IOException {
        try (InputStream is = ClusterAlertsUtil.class.getResourceAsStream(resource);){
            BytesArray bytesArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Streams.copy((InputStream)is, (OutputStream)out);
                bytesArray = new BytesArray(out.toByteArray());
            }
            return bytesArray;
        }
    }

    public static List<String> getClusterAlertsBlacklist(Exporter.Config config) {
        List blacklist = (List)Exporter.CLUSTER_ALERTS_BLACKLIST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (!blacklist.isEmpty()) {
            List<String> watchIds = Arrays.asList(WATCH_IDS);
            Set unknownIds = blacklist.stream().filter(id -> !watchIds.contains(id)).collect(Collectors.toSet());
            if (!unknownIds.isEmpty()) {
                throw new SettingsException("[" + Exporter.CLUSTER_ALERTS_BLACKLIST_SETTING.getConcreteSettingForNamespace(config.name()).getKey() + "] contains unrecognized Cluster Alert IDs [" + String.join((CharSequence)", ", unknownIds) + "]");
            }
        }
        return blacklist;
    }
}

