/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.ml;

import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.client.MachineLearningClient;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.ml.JobStatsMonitoringDoc;

public class JobStatsCollector
extends Collector {
    public static final Setting<TimeValue> JOB_STATS_TIMEOUT = JobStatsCollector.collectionTimeoutSetting("ml.job.stats.timeout");
    private final Settings settings;
    private final ThreadContext threadContext;
    private final MachineLearningClient client;

    public JobStatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, Client client) {
        this(settings, clusterService, licenseState, new XPackClient(client).machineLearning(), client.threadPool().getThreadContext());
    }

    JobStatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, MachineLearningClient client, ThreadContext threadContext) {
        super("job_stats", clusterService, JOB_STATS_TIMEOUT, licenseState);
        this.settings = settings;
        this.client = client;
        this.threadContext = threadContext;
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster) && (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(this.settings) != false && this.licenseState.isMachineLearningAllowed();
    }

    protected List<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) throws Exception {
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.threadContext, (String)"monitoring");){
            GetJobsStatsAction.Response jobs = (GetJobsStatsAction.Response)this.client.getJobsStats(new GetJobsStatsAction.Request("_all")).actionGet(this.getCollectionTimeout());
            long timestamp = JobStatsCollector.timestamp();
            String clusterUuid = JobStatsCollector.clusterUuid(clusterState);
            List<MonitoringDoc> list = jobs.getResponse().results().stream().map(jobStats -> new JobStatsMonitoringDoc(clusterUuid, timestamp, interval, node, (GetJobsStatsAction.Response.JobStats)jobStats)).collect(Collectors.toList());
            return list;
        }
    }
}

