/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.intervals.IntervalIterator;

class IntervalScorer
extends Scorer {
    private final IntervalIterator intervals;
    private final LeafSimScorer simScorer;
    private float freq = -1.0f;
    private int lastScoredDoc = -1;

    protected IntervalScorer(Weight weight, IntervalIterator intervals, LeafSimScorer simScorer) {
        super(weight);
        this.intervals = intervals;
        this.simScorer = simScorer;
    }

    public int docID() {
        return this.intervals.docID();
    }

    public float score() throws IOException {
        this.ensureFreq();
        return this.simScorer.score(this.docID(), this.freq);
    }

    public Explanation explain(String topLevel) throws IOException {
        this.ensureFreq();
        Explanation freqExplanation = Explanation.match((Number)Float.valueOf(this.freq), (String)("intervalFreq=" + this.freq), (Explanation[])new Explanation[0]);
        Explanation scoreExplanation = this.simScorer.explain(this.docID(), freqExplanation);
        return Explanation.match((Number)scoreExplanation.getValue(), (String)(topLevel + ", result of:"), (Explanation[])new Explanation[]{scoreExplanation});
    }

    public float freq() throws IOException {
        this.ensureFreq();
        return this.freq;
    }

    private void ensureFreq() throws IOException {
        if (this.lastScoredDoc != this.docID()) {
            this.lastScoredDoc = this.docID();
            this.freq = 0.0f;
            do {
                this.freq = (float)((double)this.freq + 1.0 / (double)(this.intervals.end() - this.intervals.start() + 1));
            } while (this.intervals.nextInterval() != Integer.MAX_VALUE);
        }
    }

    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator());
    }

    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.intervals){

            public boolean matches() throws IOException {
                return IntervalScorer.this.intervals.nextInterval() != Integer.MAX_VALUE;
            }

            public float matchCost() {
                return IntervalScorer.this.intervals.matchCost();
            }
        };
    }

    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }
}

