/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SnapshotShardsService.class);
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME = "internal:cluster/snapshot/update_snapshot_status";
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final SnapshotsService snapshotsService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Lock shutdownLock = new ReentrantLock();
    private final Condition shutdownCondition = this.shutdownLock.newCondition();
    private volatile Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> shardSnapshots = Collections.emptyMap();
    private final SnapshotStateExecutor snapshotStateExecutor = new SnapshotStateExecutor();
    private final UpdateSnapshotStatusAction updateSnapshotStatusHandler;

    @Inject
    public SnapshotShardsService(Settings settings, ClusterService clusterService, SnapshotsService snapshotsService, ThreadPool threadPool, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings);
        this.indicesService = indicesService;
        this.snapshotsService = snapshotsService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if (DiscoveryNode.isDataNode(settings)) {
            clusterService.addListener(this);
        }
        this.updateSnapshotStatusHandler = new UpdateSnapshotStatusAction(transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
    }

    @Override
    protected void doStart() {
        assert (this.updateSnapshotStatusHandler != null);
        assert (this.transportService.getRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME) != null);
    }

    @Override
    protected void doStop() {
        this.shutdownLock.lock();
        try {
            while (!this.shardSnapshots.isEmpty() && this.shutdownCondition.await(5L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    @Override
    protected void doClose() {
        this.clusterService.removeListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            SnapshotsInProgress previousSnapshots = (SnapshotsInProgress)event.previousState().custom("snapshots");
            SnapshotsInProgress currentSnapshots = (SnapshotsInProgress)event.state().custom("snapshots");
            if (previousSnapshots == null && currentSnapshots != null || previousSnapshots != null && !previousSnapshots.equals(currentSnapshots)) {
                this.processIndexShardSnapshots(event);
            }
            String previousMasterNodeId = event.previousState().nodes().getMasterNodeId();
            String currentMasterNodeId = event.state().nodes().getMasterNodeId();
            if (currentMasterNodeId != null && !currentMasterNodeId.equals(previousMasterNodeId)) {
                this.syncShardStatsOnNewMaster(event);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShardsMap = this.shardSnapshots;
        for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShards : snapshotShardsMap.entrySet()) {
            Map<ShardId, IndexShardSnapshotStatus> shards = snapshotShards.getValue();
            if (!shards.containsKey(shardId)) continue;
            logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
            shards.get(shardId).abortIfNotCompleted("shard is closing, aborting");
        }
    }

    public Map<ShardId, IndexShardSnapshotStatus> currentSnapshotShards(Snapshot snapshot) {
        return this.shardSnapshots.get(snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIndexShardSnapshots(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        HashMap survivors = new HashMap();
        for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> entry : this.shardSnapshots.entrySet()) {
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress != null && snapshotsInProgress.snapshot(snapshot) != null) {
                survivors.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (IndexShardSnapshotStatus snapshotStatus : entry.getValue().values()) {
                snapshotStatus.abortIfNotCompleted("snapshot has been removed in cluster state, aborting");
            }
        }
        HashMap newSnapshots = new HashMap();
        final String localNodeId = event.state().nodes().getLocalNodeId();
        HashMap snapshotIndices = new HashMap();
        if (snapshotsInProgress != null) {
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
                Map<ShardId, IndexShardSnapshotStatus> snapshotShards;
                snapshotIndices.put(entry.snapshot(), entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity())));
                if (entry.state() == SnapshotsInProgress.State.STARTED) {
                    HashMap<ShardId, IndexShardSnapshotStatus> startedShards = new HashMap<ShardId, IndexShardSnapshotStatus>();
                    Map<ShardId, IndexShardSnapshotStatus> snapshotShards2 = this.shardSnapshots.get(entry.snapshot());
                    for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                        if (!localNodeId.equals(((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).nodeId()) || ((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.State.INIT || snapshotShards2 != null && snapshotShards2.containsKey(objectObjectCursor.key)) continue;
                        logger.trace("[{}] - Adding shard to the queue", objectObjectCursor.key);
                        startedShards.put((ShardId)objectObjectCursor.key, IndexShardSnapshotStatus.newInitializing());
                    }
                    if (startedShards.isEmpty()) continue;
                    newSnapshots.put(entry.snapshot(), startedShards);
                    if (snapshotShards2 != null) {
                        HashMap shards = new HashMap();
                        shards.putAll(snapshotShards2);
                        shards.putAll(startedShards);
                        survivors.put(entry.snapshot(), Collections.unmodifiableMap(shards));
                        continue;
                    }
                    survivors.put(entry.snapshot(), Collections.unmodifiableMap(startedShards));
                    continue;
                }
                if (entry.state() != SnapshotsInProgress.State.ABORTED || (snapshotShards = this.shardSnapshots.get(entry.snapshot())) == null) continue;
                String failure = "snapshot has been aborted";
                for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                    IndexShardSnapshotStatus snapshotStatus = snapshotShards.get(objectObjectCursor.key);
                    if (snapshotStatus == null) continue;
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.abortIfNotCompleted("snapshot has been aborted");
                    IndexShardSnapshotStatus.Stage stage = lastSnapshotStatus.getStage();
                    if (stage == IndexShardSnapshotStatus.Stage.FINALIZE) {
                        logger.debug("[{}] trying to cancel snapshot on shard [{}] that is finalizing, letting it finish", (Object)entry.snapshot(), objectObjectCursor.key);
                        continue;
                    }
                    if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                        logger.debug("[{}] trying to cancel snapshot on the shard [{}] that is already done, updating status on the master", (Object)entry.snapshot(), objectObjectCursor.key);
                        this.notifySuccessfulSnapshotShard(entry.snapshot(), (ShardId)objectObjectCursor.key, localNodeId);
                        continue;
                    }
                    if (stage != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                    logger.debug("[{}] trying to cancel snapshot on the shard [{}] that has already failed, updating status on the master", (Object)entry.snapshot(), objectObjectCursor.key);
                    this.notifyFailedSnapshotShard(entry.snapshot(), (ShardId)objectObjectCursor.key, localNodeId, lastSnapshotStatus.getFailure());
                }
            }
        }
        this.shutdownLock.lock();
        try {
            this.shardSnapshots = Collections.unmodifiableMap(survivors);
            if (this.shardSnapshots.isEmpty()) {
                this.shutdownCondition.signalAll();
            }
        }
        finally {
            this.shutdownLock.unlock();
        }
        if (!newSnapshots.isEmpty()) {
            ExecutorService executor = this.threadPool.executor("snapshot");
            for (Map.Entry entry : newSnapshots.entrySet()) {
                final Snapshot snapshot = (Snapshot)entry.getKey();
                Map indicesMap = (Map)snapshotIndices.get(snapshot);
                assert (indicesMap != null);
                for (final Map.Entry shardEntry : ((Map)entry.getValue()).entrySet()) {
                    final ShardId shardId = (ShardId)shardEntry.getKey();
                    final IndexId indexId = (IndexId)indicesMap.get(shardId.getIndexName());
                    executor.execute(new AbstractRunnable(){
                        final SetOnce<Exception> failure = new SetOnce();

                        @Override
                        public void doRun() {
                            IndexShard indexShard = SnapshotShardsService.this.indicesService.indexServiceSafe(shardId.getIndex()).getShardOrNull(shardId.id());
                            assert (indexId != null);
                            SnapshotShardsService.this.snapshot(indexShard, snapshot, indexId, (IndexShardSnapshotStatus)shardEntry.getValue());
                        }

                        @Override
                        public void onFailure(Exception e) {
                            logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to snapshot shard", (Object)shardId, (Object)snapshot), (Throwable)e);
                            this.failure.set((Object)e);
                        }

                        @Override
                        public void onRejection(Exception e) {
                            this.failure.set((Object)e);
                        }

                        @Override
                        public void onAfter() {
                            Exception exception = (Exception)this.failure.get();
                            if (exception != null) {
                                SnapshotShardsService.this.notifyFailedSnapshotShard(snapshot, shardId, localNodeId, ExceptionsHelper.detailedMessage(exception));
                            } else {
                                SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, localNodeId);
                            }
                        }
                    });
                }
            }
        }
    }

    private void snapshot(IndexShard indexShard, Snapshot snapshot, IndexId indexId, IndexShardSnapshotStatus snapshotStatus) {
        ShardId shardId = indexShard.shardId();
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
        }
        if (indexShard.routingEntry().relocating()) {
            throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
        }
        IndexShardState indexShardState = indexShard.state();
        if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
            throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
        }
        Repository repository = this.snapshotsService.getRepositoriesService().repository(snapshot.getRepository());
        try (Engine.IndexCommitRef snapshotRef = indexShard.acquireLastIndexCommit(true);){
            repository.snapshotShard(indexShard, indexShard.store(), snapshot.getSnapshotId(), indexId, snapshotRef.getIndexCommit(), snapshotStatus);
            if (logger.isDebugEnabled()) {
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
                logger.debug("snapshot ({}) completed to {} with {}", (Object)snapshot, (Object)repository, (Object)lastSnapshotStatus);
            }
        }
        catch (SnapshotFailedEngineException | IndexShardSnapshotFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexShardSnapshotFailedException(shardId, "Failed to snapshot", e);
        }
    }

    private void syncShardStatsOnNewMaster(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        if (snapshotsInProgress == null) {
            return;
        }
        String localNodeId = event.state().nodes().getLocalNodeId();
        for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED || (localShards = this.currentSnapshotShards(snapshot.snapshot())) == null) continue;
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                IndexShardSnapshotStatus.Copy indexShardSnapshotStatus = localShard.getValue().asCopy();
                IndexShardSnapshotStatus.Stage stage = indexShardSnapshotStatus.getStage();
                if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, localNodeId);
                    continue;
                }
                if (stage != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                this.notifyFailedSnapshotShard(snapshot.snapshot(), shardId, localNodeId, indexShardSnapshotStatus.getFailure());
            }
        }
    }

    void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, String localNodeId) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.State.SUCCESS));
    }

    void notifyFailedSnapshotShard(Snapshot snapshot, ShardId shardId, String localNodeId, String failure) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.State.FAILED, failure));
    }

    void sendSnapshotShardUpdate(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
        try {
            UpdateIndexShardSnapshotStatusRequest request = new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status);
            this.transportService.sendRequest(this.transportService.getLocalNode(), UPDATE_SNAPSHOT_STATUS_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to update snapshot state", (Object)snapshot, (Object)status), (Throwable)e);
        }
    }

    private void innerUpdateSnapshotState(UpdateIndexShardSnapshotStatusRequest request, final ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) {
        logger.trace("received updated snapshot restore state [{}]", (Object)request);
        this.clusterService.submitStateUpdateTask("update snapshot state", request, ClusterStateTaskConfig.build(Priority.NORMAL), this.snapshotStateExecutor, new ClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new UpdateIndexShardSnapshotStatusResponse());
            }
        });
    }

    private class UpdateSnapshotStatusAction
    extends TransportMasterNodeAction<UpdateIndexShardSnapshotStatusRequest, UpdateIndexShardSnapshotStatusResponse> {
        UpdateSnapshotStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(SnapshotShardsService.UPDATE_SNAPSHOT_STATUS_ACTION_NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, UpdateIndexShardSnapshotStatusRequest::new);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected UpdateIndexShardSnapshotStatusResponse newResponse() {
            return new UpdateIndexShardSnapshotStatusResponse();
        }

        @Override
        protected void masterOperation(UpdateIndexShardSnapshotStatusRequest request, ClusterState state, ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) throws Exception {
            SnapshotShardsService.this.innerUpdateSnapshotState(request, listener);
        }

        @Override
        protected ClusterBlockException checkBlock(UpdateIndexShardSnapshotStatusRequest request, ClusterState state) {
            return null;
        }
    }

    static class UpdateIndexShardSnapshotStatusResponse
    extends ActionResponse {
        UpdateIndexShardSnapshotStatusResponse() {
        }
    }

    class SnapshotStateExecutor
    implements ClusterStateTaskExecutor<UpdateIndexShardSnapshotStatusRequest> {
        SnapshotStateExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<UpdateIndexShardSnapshotStatusRequest> execute(ClusterState currentState, List<UpdateIndexShardSnapshotStatusRequest> tasks) throws Exception {
            SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
            if (snapshots != null) {
                int changedCount = 0;
                ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
                    ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
                    boolean updated = false;
                    for (UpdateIndexShardSnapshotStatusRequest updateSnapshotState : tasks) {
                        if (!entry.snapshot().equals(updateSnapshotState.snapshot())) continue;
                        logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)updateSnapshotState.snapshot(), (Object)updateSnapshotState.shardId(), (Object)updateSnapshotState.status().state());
                        if (!updated) {
                            shards.putAll(entry.shards());
                            updated = true;
                        }
                        shards.put(updateSnapshotState.shardId(), updateSnapshotState.status());
                        ++changedCount;
                    }
                    if (updated) {
                        if (!SnapshotsInProgress.completed(shards.values())) {
                            entries.add(new SnapshotsInProgress.Entry(entry, shards.build()));
                            continue;
                        }
                        SnapshotsInProgress.Entry updatedEntry = new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.SUCCESS, shards.build());
                        entries.add(updatedEntry);
                        SnapshotShardsService.this.snapshotsService.endSnapshot(updatedEntry);
                        continue;
                    }
                    entries.add(entry);
                }
                if (changedCount > 0) {
                    logger.trace("changed cluster state triggered by {} snapshot state updates", (Object)changedCount);
                    SnapshotsInProgress updatedSnapshots = new SnapshotsInProgress(entries.toArray(new SnapshotsInProgress.Entry[entries.size()]));
                    return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(ClusterState.builder(currentState).putCustom("snapshots", updatedSnapshots).build());
                }
            }
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
        }
    }

    public static class UpdateIndexShardSnapshotStatusRequest
    extends MasterNodeRequest<UpdateIndexShardSnapshotStatusRequest> {
        private Snapshot snapshot;
        private ShardId shardId;
        private SnapshotsInProgress.ShardSnapshotStatus status;

        public UpdateIndexShardSnapshotStatusRequest() {
        }

        public UpdateIndexShardSnapshotStatusRequest(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.status = status;
            this.masterNodeTimeout = TimeValue.timeValueNanos((long)Long.MAX_VALUE);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshot = new Snapshot(in);
            this.shardId = ShardId.readShardId(in);
            this.status = new SnapshotsInProgress.ShardSnapshotStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshot.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public SnapshotsInProgress.ShardSnapshotStatus status() {
            return this.status;
        }

        public String toString() {
            return this.snapshot + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }
    }
}

