/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.RoaringDocIdSet;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.composite.BinaryValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.DoubleValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.GlobalOrdinalValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.search.aggregations.bucket.composite.LongValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

final class CompositeAggregator
extends BucketsAggregator {
    private final int size;
    private final SortedDocsProducer sortedDocsProducer;
    private final List<String> sourceNames;
    private final int[] reverseMuls;
    private final List<DocValueFormat> formats;
    private final SingleDimensionValuesSource<?>[] sources;
    private final CompositeValuesCollectorQueue queue;
    private final List<Entry> entries = new ArrayList<Entry>();
    private LeafReaderContext currentLeaf;
    private RoaringDocIdSet.Builder docIdSetBuilder;
    private BucketCollector deferredCollectors;

    CompositeAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, int size, CompositeValuesSourceConfig[] sourceConfigs, CompositeKey rawAfterKey) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.size = size;
        this.sourceNames = Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::name).collect(Collectors.toList());
        this.reverseMuls = Arrays.stream(sourceConfigs).mapToInt(CompositeValuesSourceConfig::reverseMul).toArray();
        this.formats = Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::format).collect(Collectors.toList());
        this.sources = new SingleDimensionValuesSource[sourceConfigs.length];
        for (int i = 0; i < sourceConfigs.length; ++i) {
            this.sources[i] = this.createValuesSource(context.bigArrays(), context.searcher().getIndexReader(), context.query(), sourceConfigs[i], size, i);
        }
        this.queue = new CompositeValuesCollectorQueue(context.bigArrays(), this.sources, size, rawAfterKey);
        this.sortedDocsProducer = this.sources[0].createSortedDocsProducerOrNull(context.searcher().getIndexReader(), context.query());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.queue);
        Releasables.close(this.sources);
    }

    @Override
    protected void doPreCollection() throws IOException {
        List<Aggregator> collectors = Arrays.asList(this.subAggregators);
        this.deferredCollectors = MultiBucketCollector.wrap(collectors);
        this.collectableSubAggregators = BucketCollector.NO_OP_COLLECTOR;
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.finishLeaf();
    }

    @Override
    public InternalAggregation buildAggregation(long zeroBucket) throws IOException {
        assert (zeroBucket == 0L);
        this.consumeBucketsAndMaybeBreak(this.queue.size());
        if (this.deferredCollectors != NO_OP_COLLECTOR) {
            this.runDeferredCollections();
        }
        int num = Math.min(this.size, this.queue.size());
        InternalComposite.InternalBucket[] buckets = new InternalComposite.InternalBucket[num];
        int pos = 0;
        for (int slot : this.queue.getSortedSlot()) {
            CompositeKey key = this.queue.toCompositeKey(slot);
            InternalAggregations aggs = this.bucketAggregations(slot);
            int docCount = this.queue.getDocCount(slot);
            buckets[pos++] = new InternalComposite.InternalBucket(this.sourceNames, this.formats, key, this.reverseMuls, docCount, aggs);
        }
        CompositeKey lastBucket = num > 0 ? buckets[num - 1].getRawKey() : null;
        return new InternalComposite(this.name, this.size, this.sourceNames, this.formats, Arrays.asList(buckets), lastBucket, this.reverseMuls, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalComposite(this.name, this.size, this.sourceNames, this.formats, Collections.emptyList(), null, this.reverseMuls, this.pipelineAggregators(), this.metaData());
    }

    private void finishLeaf() {
        if (this.currentLeaf != null) {
            RoaringDocIdSet docIdSet = this.docIdSetBuilder.build();
            this.entries.add(new Entry(this.currentLeaf, (DocIdSet)docIdSet));
            this.currentLeaf = null;
            this.docIdSetBuilder = null;
        }
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        boolean fillDocIdSet;
        this.finishLeaf();
        boolean bl = fillDocIdSet = this.deferredCollectors != NO_OP_COLLECTOR;
        if (this.sortedDocsProducer != null) {
            DocIdSet docIdSet = this.sortedDocsProducer.processLeaf(this.context.query(), this.queue, ctx, fillDocIdSet);
            if (fillDocIdSet) {
                this.entries.add(new Entry(ctx, docIdSet));
            }
            throw new CollectionTerminatedException();
        }
        if (fillDocIdSet) {
            this.currentLeaf = ctx;
            this.docIdSetBuilder = new RoaringDocIdSet.Builder(ctx.reader().maxDoc());
        }
        final LeafBucketCollector inner = this.queue.getLeafCollector(ctx, this.getFirstPassCollector(this.docIdSetBuilder));
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long zeroBucket) throws IOException {
                assert (zeroBucket == 0L);
                inner.collect(doc);
            }
        };
    }

    private LeafBucketCollector getFirstPassCollector(final RoaringDocIdSet.Builder builder) {
        return new LeafBucketCollector(){
            int lastDoc = -1;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                int slot = CompositeAggregator.this.queue.addIfCompetitive();
                if (slot != -1 && builder != null && this.lastDoc != doc) {
                    builder.add(doc);
                    this.lastDoc = doc;
                }
            }
        };
    }

    private void runDeferredCollections() throws IOException {
        boolean needsScores = this.scoreMode().needsScores();
        Weight weight = null;
        if (needsScores) {
            Query query = this.context.query();
            weight = this.context.searcher().createWeight(this.context.searcher().rewrite(query), ScoreMode.COMPLETE, 1.0f);
        }
        this.deferredCollectors.preCollection();
        for (Entry entry : this.entries) {
            int docID;
            Scorer scorer;
            DocIdSetIterator docIdSetIterator = entry.docIdSet.iterator();
            if (docIdSetIterator == null) continue;
            LeafBucketCollector subCollector = this.deferredCollectors.getLeafCollector(entry.context);
            LeafBucketCollector collector = this.queue.getLeafCollector(entry.context, this.getSecondPassCollector(subCollector));
            DocIdSetIterator scorerIt = null;
            if (needsScores && (scorer = weight.scorer(entry.context)) != null) {
                scorerIt = scorer.iterator();
                subCollector.setScorer((Scorable)scorer);
            }
            while ((docID = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                if (needsScores) {
                    assert (scorerIt != null && scorerIt.docID() < docID);
                    scorerIt.advance(docID);
                    assert (scorerIt.docID() == docID);
                }
                collector.collect(docID);
            }
        }
        this.deferredCollectors.postCollection();
    }

    private LeafBucketCollector getSecondPassCollector(final LeafBucketCollector subCollector) {
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long zeroBucket) throws IOException {
                assert (zeroBucket == 0L);
                Integer slot = CompositeAggregator.this.queue.compareCurrent();
                if (slot != null) {
                    subCollector.collect(doc, slot.intValue());
                }
            }
        };
    }

    private SingleDimensionValuesSource<?> createValuesSource(BigArrays bigArrays, IndexReader reader, Query query, CompositeValuesSourceConfig config, int sortRank, int size) {
        int reverseMul = config.reverseMul();
        if (config.valuesSource() instanceof ValuesSource.Bytes.WithOrdinals && reader instanceof DirectoryReader) {
            ValuesSource.Bytes.WithOrdinals vs = (ValuesSource.Bytes.WithOrdinals)config.valuesSource();
            GlobalOrdinalValuesSource source = new GlobalOrdinalValuesSource(bigArrays, config.fieldType(), (CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException>)((CheckedFunction)vs::globalOrdinalsValues), config.format(), config.missingBucket(), size, reverseMul);
            if (sortRank == 0 && ((SingleDimensionValuesSource)source).createSortedDocsProducerOrNull(reader, query) != null) {
                Releasables.close(source);
                return new BinaryValuesSource(bigArrays, this::addRequestCircuitBreakerBytes, config.fieldType(), (CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException>)((CheckedFunction)vs::bytesValues), config.format(), config.missingBucket(), size, reverseMul);
            }
            return source;
        }
        if (config.valuesSource() instanceof ValuesSource.Bytes) {
            ValuesSource.Bytes vs = (ValuesSource.Bytes)config.valuesSource();
            return new BinaryValuesSource(bigArrays, this::addRequestCircuitBreakerBytes, config.fieldType(), (CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException>)((CheckedFunction)vs::bytesValues), config.format(), config.missingBucket(), size, reverseMul);
        }
        if (config.valuesSource() instanceof ValuesSource.Numeric) {
            ValuesSource.Numeric vs = (ValuesSource.Numeric)config.valuesSource();
            if (vs.isFloatingPoint()) {
                return new DoubleValuesSource(bigArrays, config.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException>)((CheckedFunction)vs::doubleValues), config.format(), config.missingBucket(), size, reverseMul);
            }
            LongUnaryOperator rounding = vs instanceof RoundingValuesSource ? ((RoundingValuesSource)vs)::round : LongUnaryOperator.identity();
            return new LongValuesSource(bigArrays, config.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException>)((CheckedFunction)vs::longValues), rounding, config.format(), config.missingBucket(), size, reverseMul);
        }
        throw new IllegalArgumentException("Unknown values source type: " + config.valuesSource().getClass().getName() + " for source: " + config.name());
    }

    private static class Entry {
        final LeafReaderContext context;
        final DocIdSet docIdSet;

        Entry(LeafReaderContext context, DocIdSet docIdSet) {
            this.context = context;
            this.docIdSet = docIdSet;
        }
    }
}

