/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestStatusToXContentListener;

public class RestIndexAction
extends BaseRestHandler {
    public RestIndexAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}", this);
        CreateHandler createHandler = new CreateHandler(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/{id}/_create", createHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_create", createHandler);
    }

    @Override
    public String getName() {
        return "document_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean includeTypeName = request.paramAsBoolean("include_type_name", true);
        String type = request.param("type");
        if (!includeTypeName && !"_doc".equals(type)) {
            throw new IllegalArgumentException("You may only use the [include_type_name=false] option with the index APIs with the [{index}/_doc/{id}] and [{index}/_doc] endpoints.");
        }
        IndexRequest indexRequest = new IndexRequest(request.param("index"), type, request.param("id"));
        indexRequest.routing(request.param("routing"));
        indexRequest.setPipeline(request.param("pipeline"));
        indexRequest.source(request.requiredContent(), request.getXContentType());
        indexRequest.timeout(request.paramAsTime("timeout", IndexRequest.DEFAULT_TIMEOUT));
        indexRequest.setRefreshPolicy(request.param("refresh"));
        indexRequest.version(RestActions.parseVersion(request));
        indexRequest.versionType(VersionType.fromString(request.param("version_type"), indexRequest.versionType()));
        String sOpType = request.param("op_type");
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            indexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        if (sOpType != null) {
            indexRequest.opType(sOpType);
        }
        return channel -> client.index(indexRequest, new RestStatusToXContentListener<IndexResponse>((RestChannel)channel, r -> r.getLocation(indexRequest.routing())));
    }

    final class CreateHandler
    extends BaseRestHandler {
        protected CreateHandler(Settings settings) {
            super(settings);
        }

        @Override
        public String getName() {
            return "document_create_action";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
            this.validateOpType(request.params().get("op_type"));
            request.params().put("op_type", "create");
            return RestIndexAction.this.prepareRequest(request, client);
        }

        void validateOpType(String opType) {
            if (null != opType && !"create".equals(opType.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("opType must be 'create', found: [" + opType + "]");
            }
        }
    }
}

