/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public final class SearchRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));
    public static final int DEFAULT_PRE_FILTER_SHARD_SIZE = 128;
    public static final int DEFAULT_BATCHED_REDUCE_SIZE = 512;
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private SearchSourceBuilder source;
    private Boolean requestCache;
    private Boolean allowPartialSearchResults;
    private Scroll scroll;
    private int batchedReduceSize = 512;
    private int maxConcurrentShardRequests = 0;
    private int preFilterShardSize = 128;
    private String[] types = Strings.EMPTY_ARRAY;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;

    public SearchRequest() {
    }

    public SearchRequest(SearchRequest searchRequest) {
        this.allowPartialSearchResults = searchRequest.allowPartialSearchResults;
        this.batchedReduceSize = searchRequest.batchedReduceSize;
        this.indices = searchRequest.indices;
        this.indicesOptions = searchRequest.indicesOptions;
        this.maxConcurrentShardRequests = searchRequest.maxConcurrentShardRequests;
        this.preference = searchRequest.preference;
        this.preFilterShardSize = searchRequest.preFilterShardSize;
        this.requestCache = searchRequest.requestCache;
        this.routing = searchRequest.routing;
        this.scroll = searchRequest.scroll;
        this.searchType = searchRequest.searchType;
        this.source = searchRequest.source;
        this.types = searchRequest.types;
    }

    public SearchRequest(String ... indices) {
        this(indices, new SearchSourceBuilder());
    }

    public SearchRequest(String[] indices, SearchSourceBuilder source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.indices(indices);
        this.source = source;
    }

    public SearchRequest(StreamInput in) throws IOException {
        super(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.scroll = in.readOptionalWriteable(Scroll::new);
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.requestCache = in.readOptionalBoolean();
        this.batchedReduceSize = in.readVInt();
        this.maxConcurrentShardRequests = in.readVInt();
        this.preFilterShardSize = in.readVInt();
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.allowPartialSearchResults = in.readOptionalBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.searchType.id());
        out.writeVInt(this.indices.length);
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeOptionalWriteable(this.scroll);
        out.writeOptionalWriteable(this.source);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalBoolean(this.requestCache);
        out.writeVInt(this.batchedReduceSize);
        out.writeVInt(this.maxConcurrentShardRequests);
        out.writeVInt(this.preFilterShardSize);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeOptionalBoolean(this.allowPartialSearchResults);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        Scroll scroll = this.scroll();
        if (this.source != null && !this.source.trackTotalHits() && scroll != null) {
            validationException = ValidateActions.addValidationError("disabling [track_total_hits] is not allowed in a scroll context", validationException);
        }
        if (this.source != null && this.source.from() > 0 && scroll != null) {
            validationException = ValidateActions.addValidationError("using [from] is not allowed in a scroll context", validationException);
        }
        if (this.requestCache != null && this.requestCache.booleanValue() && scroll != null) {
            validationException = ValidateActions.addValidationError("[request_cache] cannot be used in a scroll context", validationException);
        }
        if (this.source != null && this.source.size() == 0 && scroll != null) {
            validationException = ValidateActions.addValidationError("[size] cannot be [0] in a scroll context", validationException);
        }
        if (this.source != null && this.source.rescores() != null && !this.source.rescores().isEmpty() && scroll != null) {
            validationException = ValidateActions.addValidationError("using [rescore] is not allowed in a scroll context", validationException);
        }
        return validationException;
    }

    @Override
    public SearchRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public SearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
        return this;
    }

    @Deprecated
    public String[] types() {
        return this.types;
    }

    @Deprecated
    public SearchRequest types(String ... types) {
        Objects.requireNonNull(types, "types must not be null");
        for (String type : types) {
            Objects.requireNonNull(type, "type must not be null");
        }
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = Objects.requireNonNull(searchType, "searchType must not be null");
        return this;
    }

    public SearchRequest searchType(String searchType) {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        this.source = Objects.requireNonNull(sourceBuilder, "source must not be null");
        return this;
    }

    public SearchSourceBuilder source() {
        return this.source;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue((String)keepAlive, null, (String)(this.getClass().getSimpleName() + ".Scroll.keepAlive"))));
    }

    public SearchRequest requestCache(Boolean requestCache) {
        this.requestCache = requestCache;
        return this;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    public SearchRequest allowPartialSearchResults(boolean allowPartialSearchResults) {
        this.allowPartialSearchResults = allowPartialSearchResults;
        return this;
    }

    public Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public void setBatchedReduceSize(int batchedReduceSize) {
        if (batchedReduceSize <= 1) {
            throw new IllegalArgumentException("batchedReduceSize must be >= 2");
        }
        this.batchedReduceSize = batchedReduceSize;
    }

    public int getBatchedReduceSize() {
        return this.batchedReduceSize;
    }

    public int getMaxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests == 0 ? 5 : this.maxConcurrentShardRequests;
    }

    public void setMaxConcurrentShardRequests(int maxConcurrentShardRequests) {
        if (maxConcurrentShardRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentShardRequests must be >= 1");
        }
        this.maxConcurrentShardRequests = maxConcurrentShardRequests;
    }

    public void setPreFilterShardSize(int preFilterShardSize) {
        if (preFilterShardSize < 1) {
            throw new IllegalArgumentException("preFilterShardSize must be >= 1");
        }
        this.preFilterShardSize = preFilterShardSize;
    }

    public int getPreFilterShardSize() {
        return this.preFilterShardSize;
    }

    boolean isMaxConcurrentShardRequestsSet() {
        return this.maxConcurrentShardRequests != 0;
    }

    public boolean isSuggestOnly() {
        return this.source != null && this.source.isSuggestOnly();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, null, parentTaskId, headers){

            @Override
            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                sb.append("indices[");
                Strings.arrayToDelimitedString(SearchRequest.this.indices, ",", sb);
                sb.append("], ");
                sb.append("types[");
                Strings.arrayToDelimitedString(SearchRequest.this.types, ",", sb);
                sb.append("], ");
                sb.append("search_type[").append((Object)SearchRequest.this.searchType).append("], ");
                if (SearchRequest.this.source != null) {
                    sb.append("source[").append(SearchRequest.this.source.toString(FORMAT_PARAMS)).append("]");
                } else {
                    sb.append("source[]");
                }
                return sb.toString();
            }
        };
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequest that = (SearchRequest)o;
        return this.searchType == that.searchType && Arrays.equals(this.indices, that.indices) && Objects.equals(this.routing, that.routing) && Objects.equals(this.preference, that.preference) && Objects.equals(this.source, that.source) && Objects.equals(this.requestCache, that.requestCache) && Objects.equals(this.scroll, that.scroll) && Arrays.equals(this.types, that.types) && Objects.equals(this.batchedReduceSize, that.batchedReduceSize) && Objects.equals(this.maxConcurrentShardRequests, that.maxConcurrentShardRequests) && Objects.equals(this.preFilterShardSize, that.preFilterShardSize) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.allowPartialSearchResults, that.allowPartialSearchResults);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.searchType, Arrays.hashCode(this.indices), this.routing, this.preference, this.source, this.requestCache, this.scroll, Arrays.hashCode(this.types), this.indicesOptions, this.batchedReduceSize, this.maxConcurrentShardRequests, this.preFilterShardSize, this.allowPartialSearchResults});
    }

    public String toString() {
        return "SearchRequest{searchType=" + (Object)((Object)this.searchType) + ", indices=" + Arrays.toString(this.indices) + ", indicesOptions=" + this.indicesOptions + ", types=" + Arrays.toString(this.types) + ", routing='" + this.routing + '\'' + ", preference='" + this.preference + '\'' + ", requestCache=" + this.requestCache + ", scroll=" + this.scroll + ", maxConcurrentShardRequests=" + this.maxConcurrentShardRequests + ", batchedReduceSize=" + this.batchedReduceSize + ", preFilterShardSize=" + this.preFilterShardSize + ", allowPartialSearchResults=" + this.allowPartialSearchResults + ", source=" + this.source + '}';
    }
}

