/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class RolloverRequest
extends AcknowledgedRequest<RolloverRequest>
implements IndicesRequest,
ToXContentObject {
    private static final ObjectParser<RolloverRequest, Void> PARSER = new ObjectParser("rollover");
    private static final ObjectParser<Map<String, Condition<?>>, Void> CONDITION_PARSER = new ObjectParser("conditions");
    private static final ParseField CONDITIONS = new ParseField("conditions", new String[0]);
    private static final ParseField MAX_AGE_CONDITION = new ParseField("max_age", new String[0]);
    private static final ParseField MAX_DOCS_CONDITION = new ParseField("max_docs", new String[0]);
    private static final ParseField MAX_SIZE_CONDITION = new ParseField("max_size", new String[0]);
    private String alias;
    private String newIndexName;
    private boolean dryRun;
    private Map<String, Condition<?>> conditions = new HashMap(2);
    private CreateIndexRequest createIndexRequest = new CreateIndexRequest("_na_");

    RolloverRequest() {
    }

    public RolloverRequest(String alias, String newIndexName) {
        this.alias = alias;
        this.newIndexName = newIndexName;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = this.createIndexRequest.validate();
        if (this.alias == null) {
            validationException = ValidateActions.addValidationError("index alias is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.alias = in.readString();
        this.newIndexName = in.readOptionalString();
        this.dryRun = in.readBoolean();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            Condition condition = in.readNamedWriteable(Condition.class);
            this.conditions.put(condition.name, condition);
        }
        this.createIndexRequest = new CreateIndexRequest();
        this.createIndexRequest.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.alias);
        out.writeOptionalString(this.newIndexName);
        out.writeBoolean(this.dryRun);
        out.writeVInt(this.conditions.size());
        for (Condition<?> condition : this.conditions.values()) {
            if (!condition.includedInVersion(out.getVersion())) continue;
            out.writeNamedWriteable(condition);
        }
        this.createIndexRequest.writeTo(out);
    }

    @Override
    public String[] indices() {
        return new String[]{this.alias};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setNewIndexName(String newIndexName) {
        this.newIndexName = newIndexName;
    }

    public void dryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void addMaxIndexAgeCondition(TimeValue age) {
        MaxAgeCondition maxAgeCondition = new MaxAgeCondition(age);
        if (this.conditions.containsKey(maxAgeCondition.name)) {
            throw new IllegalArgumentException(maxAgeCondition.name + " condition is already set");
        }
        this.conditions.put(maxAgeCondition.name, maxAgeCondition);
    }

    public void addMaxIndexDocsCondition(long numDocs) {
        MaxDocsCondition maxDocsCondition = new MaxDocsCondition(numDocs);
        if (this.conditions.containsKey(maxDocsCondition.name)) {
            throw new IllegalArgumentException(maxDocsCondition.name + " condition is already set");
        }
        this.conditions.put(maxDocsCondition.name, maxDocsCondition);
    }

    public void addMaxIndexSizeCondition(ByteSizeValue size) {
        MaxSizeCondition maxSizeCondition = new MaxSizeCondition(size);
        if (this.conditions.containsKey(maxSizeCondition.name)) {
            throw new IllegalArgumentException(maxSizeCondition + " condition is already set");
        }
        this.conditions.put(maxSizeCondition.name, maxSizeCondition);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Map<String, Condition<?>> getConditions() {
        return this.conditions;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getNewIndexName() {
        return this.newIndexName;
    }

    public CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.createIndexRequest.innerToXContent(builder, params);
        builder.startObject(CONDITIONS.getPreferredName());
        for (Condition<?> condition : this.conditions.values()) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        PARSER.parse(parser, (Object)this, null);
    }

    static {
        CONDITION_PARSER.declareString((conditions, s) -> conditions.put("max_age", new MaxAgeCondition(TimeValue.parseTimeValue((String)s, (String)"max_age"))), MAX_AGE_CONDITION);
        CONDITION_PARSER.declareLong((conditions, value) -> conditions.put("max_docs", new MaxDocsCondition((Long)value)), MAX_DOCS_CONDITION);
        CONDITION_PARSER.declareString((conditions, s) -> conditions.put("max_size", new MaxSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "max_size"))), MAX_SIZE_CONDITION);
        PARSER.declareField((parser, request, context) -> CONDITION_PARSER.parse(parser, request.conditions, null), CONDITIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.settings(parser.map()), CreateIndexRequest.SETTINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> {
            for (Map.Entry mappingsEntry : parser.map().entrySet()) {
                request.createIndexRequest.mapping((String)mappingsEntry.getKey(), (Map)mappingsEntry.getValue());
            }
        }, CreateIndexRequest.MAPPINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.aliases(parser.map()), CreateIndexRequest.ALIASES, ObjectParser.ValueType.OBJECT);
    }
}

