/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.mapper.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.FeatureFieldMapper;
import org.elasticsearch.index.mapper.FeatureMetaFieldMapper;
import org.elasticsearch.index.mapper.FeatureVectorFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ScaledFloatFieldMapper;
import org.elasticsearch.index.mapper.SparseVectorFieldMapper;
import org.elasticsearch.index.mapper.TokenCountFieldMapper;
import org.elasticsearch.index.query.FeatureQueryBuilder;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;

public class MapperExtrasPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, Object> mappers = new LinkedHashMap<String, Object>();
        mappers.put("scaled_float", new ScaledFloatFieldMapper.TypeParser());
        mappers.put("token_count", new TokenCountFieldMapper.TypeParser());
        mappers.put("feature", new FeatureFieldMapper.TypeParser());
        mappers.put("feature_vector", new FeatureVectorFieldMapper.TypeParser());
        mappers.put("dense_vector", new DenseVectorFieldMapper.TypeParser());
        mappers.put("sparse_vector", new SparseVectorFieldMapper.TypeParser());
        return Collections.unmodifiableMap(mappers);
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_feature", new FeatureMetaFieldMapper.TypeParser());
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("feature", FeatureQueryBuilder::new, p -> (FeatureQueryBuilder)((Object)((Object)FeatureQueryBuilder.PARSER.parse(p, null)))));
    }
}

