/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeAction;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeInfoAction;
import org.elasticsearch.xpack.upgrade.IndexUpgradeCheck;
import org.elasticsearch.xpack.upgrade.IndexUpgradeService;
import org.elasticsearch.xpack.upgrade.actions.TransportIndexUpgradeAction;
import org.elasticsearch.xpack.upgrade.actions.TransportIndexUpgradeInfoAction;
import org.elasticsearch.xpack.upgrade.rest.RestIndexUpgradeAction;
import org.elasticsearch.xpack.upgrade.rest.RestIndexUpgradeInfoAction;

public class Upgrade
extends Plugin
implements ActionPlugin {
    public static final Version UPGRADE_INTRODUCED = Version.CURRENT.minimumCompatibilityVersion();
    private final List<BiFunction<Client, ClusterService, IndexUpgradeCheck>> upgradeCheckFactories = new ArrayList<BiFunction<Client, ClusterService, IndexUpgradeCheck>>();

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        ArrayList<IndexUpgradeCheck> upgradeChecks = new ArrayList<IndexUpgradeCheck>(this.upgradeCheckFactories.size());
        for (BiFunction<Client, ClusterService, IndexUpgradeCheck> checkFactory : this.upgradeCheckFactories) {
            upgradeChecks.add(checkFactory.apply(client, clusterService));
        }
        return Collections.singletonList(new IndexUpgradeService(Collections.unmodifiableList(upgradeChecks)));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((Action)IndexUpgradeInfoAction.INSTANCE, TransportIndexUpgradeInfoAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)IndexUpgradeAction.INSTANCE, TransportIndexUpgradeAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestIndexUpgradeInfoAction(settings, restController), new RestIndexUpgradeAction(settings, restController)});
    }
}

