/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.get;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.core.watcher.watch.WatchStatus;

public class GetWatchResponse
extends ActionResponse
implements ToXContent {
    private String id;
    private WatchStatus status;
    private boolean found;
    private XContentSource source;
    private long version;

    public GetWatchResponse() {
    }

    public GetWatchResponse(String id) {
        this.id = id;
        this.status = null;
        this.found = false;
        this.source = null;
        this.version = -1L;
    }

    public GetWatchResponse(String id, long version, WatchStatus status, XContentSource source) {
        this.id = id;
        this.status = status;
        this.found = true;
        this.source = source;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public WatchStatus getStatus() {
        return this.status;
    }

    public boolean isFound() {
        return this.found;
    }

    public XContentSource getSource() {
        return this.source;
    }

    public long getVersion() {
        return this.version;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.found = in.readBoolean();
        if (this.found) {
            this.status = WatchStatus.read(in);
            this.source = XContentSource.readFrom(in);
            this.version = in.readZLong();
        } else {
            this.status = null;
            this.source = null;
            this.version = -1L;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBoolean(this.found);
        if (this.found) {
            this.status.writeTo(out);
            XContentSource.writeTo(this.source, out);
            out.writeZLong(this.version);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("found", this.found);
        builder.field("_id", this.id);
        if (this.found) {
            builder.field("_version", this.version);
            builder.field("status", (ToXContent)this.status, params);
            builder.field("watch", (ToXContent)this.source, params);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetWatchResponse that = (GetWatchResponse)((Object)o);
        return this.version == that.version && Objects.equals(this.id, that.id) && Objects.equals(this.status, that.status) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.version);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

