/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class GetCertificateInfoAction
extends Action<Response> {
    public static final GetCertificateInfoAction INSTANCE = new GetCertificateInfoAction();
    public static final String NAME = "cluster:monitor/xpack/ssl/certificates/get";

    private GetCertificateInfoAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client, GetCertificateInfoAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }

        public RequestBuilder(ElasticsearchClient client) {
            this(client, INSTANCE);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Collection<CertificateInfo> certificates;

        public Response() {
        }

        public Response(Collection<CertificateInfo> certificates) {
            this.certificates = certificates;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (CertificateInfo cert : this.certificates) {
                cert.toXContent(builder, params);
            }
            return builder.endArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.certificates.size());
            for (CertificateInfo cert : this.certificates) {
                cert.writeTo(out);
            }
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.certificates = new ArrayList<CertificateInfo>();
            int count = in.readVInt();
            for (int i = 0; i < count; ++i) {
                this.certificates.add(new CertificateInfo(in));
            }
        }
    }

    public static class Request
    extends ActionRequest {
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

