/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;

public class RealmSettings {
    public static final String PREFIX = "xpack.security.authc.realms.";
    public static final Function<String, Setting.AffixSetting<Boolean>> ENABLED_SETTING = RealmSettings.affixSetting("enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<Integer>> ORDER_SETTING = RealmSettings.affixSetting("order", key -> Setting.intSetting((String)key, (int)Integer.MAX_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));

    public static String realmSettingPrefix(String type) {
        return PREFIX + type + ".";
    }

    public static String realmSettingPrefix(RealmConfig.RealmIdentifier identifier) {
        return RealmSettings.realmSettingPrefix(identifier.getType()) + identifier.getName() + ".";
    }

    public static String realmSslPrefix(RealmConfig.RealmIdentifier identifier) {
        return RealmSettings.realmSettingPrefix(identifier) + "ssl.";
    }

    public static Setting.AffixSetting<String> simpleString(String realmType, String suffix, Setting.Property ... properties) {
        return Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(realmType), (String)suffix, key -> Setting.simpleString((String)key, (Setting.Property[])properties), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    }

    public static <T> Function<String, Setting.AffixSetting<T>> affixSetting(String suffix, Function<String, Setting<T>> delegateFactory) {
        return realmType -> Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix(realmType), (String)suffix, (Function)delegateFactory, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    }

    public static Map<RealmConfig.RealmIdentifier, Settings> getRealmSettings(Settings globalSettings) {
        Settings settingsByType = globalSettings.getByPrefix(PREFIX);
        return settingsByType.names().stream().flatMap(type -> {
            Settings settingsByName = settingsByType.getAsSettings(type);
            return settingsByName.names().stream().map(name -> {
                RealmConfig.RealmIdentifier id = new RealmConfig.RealmIdentifier((String)type, (String)name);
                Settings realmSettings = settingsByName.getAsSettings(name);
                return new Tuple((Object)id, (Object)realmSettings);
            });
        }).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
    }

    public static String getFullSettingKey(String realmName, Setting.AffixSetting<?> setting) {
        return setting.getConcreteSettingForNamespace(realmName).getKey();
    }

    public static String getFullSettingKey(RealmConfig realm, Setting.AffixSetting<?> setting) {
        return setting.getConcreteSettingForNamespace(realm.name()).getKey();
    }

    public static <T> String getFullSettingKey(RealmConfig.RealmIdentifier realmId, Function<String, Setting.AffixSetting<T>> setting) {
        return RealmSettings.getFullSettingKey(realmId.getName(), setting.apply(realmId.getType()));
    }

    public static <T> String getFullSettingKey(RealmConfig realm, Function<String, Setting.AffixSetting<T>> setting) {
        return RealmSettings.getFullSettingKey(realm.identifier, setting);
    }

    public static List<Setting.AffixSetting<?>> getStandardSettings(String realmType) {
        return Arrays.asList(ENABLED_SETTING.apply(realmType), ORDER_SETTING.apply(realmType));
    }

    private RealmSettings() {
    }
}

