/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class HasPrivilegesResponse
extends ActionResponse
implements ToXContentObject {
    private String username;
    private boolean completeMatch;
    private Map<String, Boolean> cluster;
    private Set<ResourcePrivileges> index;
    private Map<String, Set<ResourcePrivileges>> application;

    public HasPrivilegesResponse() {
        this("", true, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap());
    }

    public HasPrivilegesResponse(String username, boolean completeMatch, Map<String, Boolean> cluster, Collection<ResourcePrivileges> index, Map<String, Collection<ResourcePrivileges>> application) {
        this.username = username;
        this.completeMatch = completeMatch;
        this.cluster = Collections.unmodifiableMap(cluster);
        this.index = Collections.unmodifiableSet(HasPrivilegesResponse.sorted(index));
        HashMap applicationPrivileges = new HashMap();
        application.forEach((key, val) -> applicationPrivileges.put(key, Collections.unmodifiableSet(HasPrivilegesResponse.sorted(val))));
        this.application = Collections.unmodifiableMap(applicationPrivileges);
    }

    private static Set<ResourcePrivileges> sorted(Collection<ResourcePrivileges> resources) {
        TreeSet<ResourcePrivileges> set = new TreeSet<ResourcePrivileges>(Comparator.comparing(o -> ((ResourcePrivileges)o).resource));
        set.addAll(resources);
        return set;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isCompleteMatch() {
        return this.completeMatch;
    }

    public Map<String, Boolean> getClusterPrivileges() {
        return this.cluster;
    }

    public Set<ResourcePrivileges> getIndexPrivileges() {
        return this.index;
    }

    public Map<String, Set<ResourcePrivileges>> getApplicationPrivileges() {
        return this.application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HasPrivilegesResponse response = (HasPrivilegesResponse)((Object)o);
        return this.completeMatch == response.completeMatch && Objects.equals(this.username, response.username) && Objects.equals(this.cluster, response.cluster) && Objects.equals(this.index, response.index) && Objects.equals(this.application, response.application);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.completeMatch, this.cluster, this.index, this.application);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.completeMatch = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.cluster = in.readMap(StreamInput::readString, StreamInput::readBoolean);
        }
        this.index = HasPrivilegesResponse.readResourcePrivileges(in);
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.application = in.readMap(StreamInput::readString, HasPrivilegesResponse::readResourcePrivileges);
        }
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.username = in.readString();
        }
    }

    private static Set<ResourcePrivileges> readResourcePrivileges(StreamInput in) throws IOException {
        int count = in.readVInt();
        TreeSet<ResourcePrivileges> set = new TreeSet<ResourcePrivileges>(Comparator.comparing(o -> ((ResourcePrivileges)o).resource));
        for (int i = 0; i < count; ++i) {
            String index = in.readString();
            Map privileges = in.readMap(StreamInput::readString, StreamInput::readBoolean);
            set.add(new ResourcePrivileges(index, privileges));
        }
        return set;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.completeMatch);
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeMap(this.cluster, StreamOutput::writeString, StreamOutput::writeBoolean);
        }
        HasPrivilegesResponse.writeResourcePrivileges(out, this.index);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeMap(this.application, StreamOutput::writeString, HasPrivilegesResponse::writeResourcePrivileges);
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeString(this.username);
        }
    }

    private static void writeResourcePrivileges(StreamOutput out, Set<ResourcePrivileges> privileges) throws IOException {
        out.writeVInt(privileges.size());
        for (ResourcePrivileges priv : privileges) {
            out.writeString(priv.resource);
            out.writeMap(priv.privileges, StreamOutput::writeString, StreamOutput::writeBoolean);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{username=" + this.username + ",completeMatch=" + this.completeMatch + ",cluster=" + this.cluster + ",index=" + this.index + ",application=" + this.application + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("username", this.username).field("has_all_requested", this.completeMatch);
        builder.field("cluster");
        builder.map(this.cluster);
        this.appendResources(builder, "index", this.index);
        builder.startObject("application");
        for (String app : this.application.keySet()) {
            this.appendResources(builder, app, this.application.get(app));
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private void appendResources(XContentBuilder builder, String field, Set<ResourcePrivileges> privileges) throws IOException {
        builder.startObject(field);
        for (ResourcePrivileges privilege : privileges) {
            builder.field(privilege.getResource());
            builder.map(privilege.getPrivileges());
        }
        builder.endObject();
    }

    public static class ResourcePrivileges {
        private final String resource;
        private final Map<String, Boolean> privileges;

        public ResourcePrivileges(String resource, Map<String, Boolean> privileges) {
            this.resource = Objects.requireNonNull(resource);
            this.privileges = Collections.unmodifiableMap(privileges);
        }

        public String getResource() {
            return this.resource;
        }

        public Map<String, Boolean> getPrivileges() {
            return this.privileges;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{resource='" + this.resource + '\'' + ", privileges=" + this.privileges + '}';
        }

        public int hashCode() {
            int result = this.resource.hashCode();
            result = 31 * result + this.privileges.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourcePrivileges other = (ResourcePrivileges)o;
            return this.resource.equals(other.resource) && this.privileges.equals(other.privileges);
        }
    }
}

