/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateCalendarJobAction
extends Action<PutCalendarAction.Response> {
    public static final UpdateCalendarJobAction INSTANCE = new UpdateCalendarJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/jobs/update";

    private UpdateCalendarJobAction() {
        super(NAME);
    }

    public PutCalendarAction.Response newResponse() {
        return new PutCalendarAction.Response();
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, PutCalendarAction.Response> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest {
        private String calendarId;
        private String jobIdsToAddExpression;
        private String jobIdsToRemoveExpression;

        public Request() {
        }

        public Request(String calendarId, String jobIdsToAddExpression, String jobIdsToRemoveExpression) {
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
            this.jobIdsToAddExpression = jobIdsToAddExpression;
            this.jobIdsToRemoveExpression = jobIdsToRemoveExpression;
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public String getJobIdsToAddExpression() {
            return this.jobIdsToAddExpression;
        }

        public String getJobIdsToRemoveExpression() {
            return this.jobIdsToRemoveExpression;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.calendarId = in.readString();
            this.jobIdsToAddExpression = in.readOptionalString();
            this.jobIdsToRemoveExpression = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
            out.writeOptionalString(this.jobIdsToAddExpression);
            out.writeOptionalString(this.jobIdsToRemoveExpression);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId, this.jobIdsToAddExpression, this.jobIdsToRemoveExpression);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.jobIdsToAddExpression, other.jobIdsToAddExpression) && Objects.equals(this.jobIdsToRemoveExpression, other.jobIdsToRemoveExpression);
        }
    }
}

