/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;

public class GetFiltersAction
extends Action<Response> {
    public static final GetFiltersAction INSTANCE = new GetFiltersAction();
    public static final String NAME = "cluster:admin/xpack/ml/filters/get";

    private GetFiltersAction() {
        super(NAME);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends ActionResponse
    implements StatusToXContentObject {
        private QueryPage<MlFilter> filters;

        public Response(QueryPage<MlFilter> filters) {
            this.filters = filters;
        }

        public Response() {
        }

        public QueryPage<MlFilter> getFilters() {
            return this.filters;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.filters = new QueryPage(in, MlFilter::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.filters.writeTo(out);
        }

        public RestStatus status() {
            return RestStatus.OK;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.filters.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.filters);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.filters, other.filters);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest {
        private String filterId;
        private PageParams pageParams;

        public void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        public String getFilterId() {
            return this.filterId;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = pageParams;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.pageParams != null && this.filterId != null) {
                validationException = ValidateActions.addValidationError((String)("Params [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] are incompatible with [" + MlFilter.ID.getPreferredName() + "]"), validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.filterId = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.filterId);
        }

        public int hashCode() {
            return Objects.hash(this.filterId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.filterId, other.filterId);
        }
    }
}

