/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.BiConsumer;

public class FlushOperation {
    private final BiConsumer<Void, Exception> listener;
    private final ByteBuffer[] buffers;
    private final int[] offsets;
    private final int length;
    private int internalIndex;

    public FlushOperation(ByteBuffer[] buffers, BiConsumer<Void, Exception> listener) {
        this.listener = listener;
        this.buffers = buffers;
        this.offsets = new int[buffers.length];
        int offset = 0;
        for (int i = 0; i < buffers.length; ++i) {
            ByteBuffer buffer = buffers[i];
            this.offsets[i] = offset;
            offset += buffer.remaining();
        }
        this.length = offset;
    }

    public BiConsumer<Void, Exception> getListener() {
        return this.listener;
    }

    public boolean isFullyFlushed() {
        assert (this.length >= this.internalIndex) : "Should never have an index that is greater than the length [length=" + this.length + ", index=" + this.internalIndex + "]";
        return this.internalIndex == this.length;
    }

    public void incrementIndex(int delta) {
        this.internalIndex += delta;
        assert (this.length >= this.internalIndex) : "Should never increment index past length [length=" + this.length + ", post-increment index=" + this.internalIndex + ", delta=" + delta + "]";
    }

    public ByteBuffer[] getBuffersToWrite() {
        int index = Arrays.binarySearch(this.offsets, this.internalIndex);
        int offsetIndex = index < 0 ? -(index + 1) - 1 : index;
        ByteBuffer[] postIndexBuffers = new ByteBuffer[this.buffers.length - offsetIndex];
        ByteBuffer firstBuffer = this.buffers[offsetIndex].duplicate();
        firstBuffer.position(this.internalIndex - this.offsets[offsetIndex]);
        postIndexBuffers[0] = firstBuffer;
        int j = 1;
        for (int i = offsetIndex + 1; i < this.buffers.length; ++i) {
            postIndexBuffers[j++] = this.buffers[i].duplicate();
        }
        return postIndexBuffers;
    }
}

