/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.function.Supplier;
import org.elasticsearch.nio.NioChannel;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.ServerChannelContext;

public abstract class ChannelFactory<ServerSocket extends NioServerSocketChannel, Socket extends NioSocketChannel> {
    private final RawChannelFactory rawChannelFactory;

    protected ChannelFactory(RawChannelFactory rawChannelFactory) {
        this.rawChannelFactory = rawChannelFactory;
    }

    public Socket openNioChannel(InetSocketAddress remoteAddress, Supplier<NioSelector> supplier) throws IOException {
        SocketChannel rawChannel = this.rawChannelFactory.openNioChannel(remoteAddress);
        NioSelector selector = supplier.get();
        Socket channel = this.internalCreateChannel(selector, rawChannel);
        this.scheduleChannel(channel, selector);
        return channel;
    }

    public Socket acceptNioChannel(ServerChannelContext serverContext, Supplier<NioSelector> supplier) throws IOException {
        SocketChannel rawChannel = this.rawChannelFactory.acceptNioChannel(serverContext);
        if (rawChannel == null) {
            return null;
        }
        NioSelector selector = supplier.get();
        Socket channel = this.internalCreateChannel(selector, rawChannel);
        this.scheduleChannel(channel, selector);
        return channel;
    }

    public ServerSocket openNioServerSocketChannel(InetSocketAddress address, Supplier<NioSelector> supplier) throws IOException {
        ServerSocketChannel rawChannel = this.rawChannelFactory.openNioServerSocketChannel(address);
        NioSelector selector = supplier.get();
        ServerSocket serverChannel = this.internalCreateServerChannel(selector, rawChannel);
        this.scheduleServerChannel(serverChannel, selector);
        return serverChannel;
    }

    public abstract Socket createChannel(NioSelector var1, SocketChannel var2) throws IOException;

    public abstract ServerSocket createServerChannel(NioSelector var1, ServerSocketChannel var2) throws IOException;

    private Socket internalCreateChannel(NioSelector selector, SocketChannel rawChannel) throws IOException {
        try {
            Socket channel = this.createChannel(selector, rawChannel);
            assert (((NioSocketChannel)channel).getContext() != null) : "channel context should have been set on channel";
            return channel;
        }
        catch (UncheckedIOException e) {
            IOException cause = e.getCause();
            ChannelFactory.closeRawChannel(rawChannel, cause);
            throw cause;
        }
        catch (Exception e) {
            ChannelFactory.closeRawChannel(rawChannel, e);
            throw e;
        }
    }

    private ServerSocket internalCreateServerChannel(NioSelector selector, ServerSocketChannel rawChannel) throws IOException {
        try {
            return this.createServerChannel(selector, rawChannel);
        }
        catch (Exception e) {
            ChannelFactory.closeRawChannel(rawChannel, e);
            throw e;
        }
    }

    private void scheduleChannel(Socket channel, NioSelector selector) {
        try {
            selector.scheduleForRegistration((NioChannel)channel);
        }
        catch (IllegalStateException e) {
            ChannelFactory.closeRawChannel(((NioSocketChannel)channel).getRawChannel(), e);
            throw e;
        }
    }

    private void scheduleServerChannel(ServerSocket channel, NioSelector selector) {
        try {
            selector.scheduleForRegistration((NioChannel)channel);
        }
        catch (IllegalStateException e) {
            ChannelFactory.closeRawChannel(((NioServerSocketChannel)channel).getRawChannel(), e);
            throw e;
        }
    }

    private static void closeRawChannel(Closeable c, Exception e) {
        try {
            c.close();
        }
        catch (IOException closeException) {
            e.addSuppressed(closeException);
        }
    }

    public static class RawChannelFactory {
        private final boolean tcpNoDelay;
        private final boolean tcpKeepAlive;
        private final boolean tcpReusedAddress;
        private final int tcpSendBufferSize;
        private final int tcpReceiveBufferSize;

        public RawChannelFactory(boolean tcpNoDelay, boolean tcpKeepAlive, boolean tcpReusedAddress, int tcpSendBufferSize, int tcpReceiveBufferSize) {
            this.tcpNoDelay = tcpNoDelay;
            this.tcpKeepAlive = tcpKeepAlive;
            this.tcpReusedAddress = tcpReusedAddress;
            this.tcpSendBufferSize = tcpSendBufferSize;
            this.tcpReceiveBufferSize = tcpReceiveBufferSize;
        }

        SocketChannel openNioChannel(InetSocketAddress remoteAddress) throws IOException {
            SocketChannel socketChannel = SocketChannel.open();
            try {
                this.configureSocketChannel(socketChannel);
                RawChannelFactory.connect(socketChannel, remoteAddress);
            }
            catch (IOException e) {
                ChannelFactory.closeRawChannel(socketChannel, e);
                throw e;
            }
            return socketChannel;
        }

        SocketChannel acceptNioChannel(ServerChannelContext serverContext) throws IOException {
            ServerSocketChannel rawChannel = serverContext.getChannel().getRawChannel();
            SocketChannel socketChannel = RawChannelFactory.accept(rawChannel);
            if (socketChannel == null) {
                return null;
            }
            try {
                this.configureSocketChannel(socketChannel);
            }
            catch (IOException e) {
                ChannelFactory.closeRawChannel(socketChannel, e);
                throw e;
            }
            return socketChannel;
        }

        ServerSocketChannel openNioServerSocketChannel(InetSocketAddress address) throws IOException {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            ServerSocket socket = serverSocketChannel.socket();
            try {
                socket.setReuseAddress(this.tcpReusedAddress);
                serverSocketChannel.bind(address);
            }
            catch (IOException e) {
                ChannelFactory.closeRawChannel(serverSocketChannel, e);
                throw e;
            }
            return serverSocketChannel;
        }

        private void configureSocketChannel(SocketChannel channel) throws IOException {
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            socket.setTcpNoDelay(this.tcpNoDelay);
            socket.setKeepAlive(this.tcpKeepAlive);
            socket.setReuseAddress(this.tcpReusedAddress);
            if (this.tcpSendBufferSize > 0) {
                socket.setSendBufferSize(this.tcpSendBufferSize);
            }
            if (this.tcpReceiveBufferSize > 0) {
                socket.setSendBufferSize(this.tcpReceiveBufferSize);
            }
        }

        public static SocketChannel accept(ServerSocketChannel serverSocketChannel) throws IOException {
            try {
                return AccessController.doPrivileged(serverSocketChannel::accept);
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
        }

        private static void connect(SocketChannel socketChannel, InetSocketAddress remoteAddress) throws IOException {
            try {
                AccessController.doPrivileged(() -> socketChannel.connect(remoteAddress));
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getCause();
            }
        }
    }
}

