/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;

public class CcrRepository
extends AbstractLifecycleComponent
implements Repository {
    public static final String LATEST = "_latest_";
    public static final String TYPE = "_ccr_";
    public static final String NAME_PREFIX = "_ccr_";
    private static final SnapshotId SNAPSHOT_ID = new SnapshotId("_latest_", "_latest_");
    private final RepositoryMetaData metadata;
    private final String remoteClusterAlias;
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;

    public CcrRepository(RepositoryMetaData metadata, Client client, CcrLicenseChecker ccrLicenseChecker, Settings settings) {
        super(settings);
        this.metadata = metadata;
        assert (metadata.name().startsWith("_ccr_")) : "CcrRepository metadata.name() must start with: _ccr_";
        this.remoteClusterAlias = Strings.split((String)metadata.name(), (String)"_ccr_")[1];
        this.ccrLicenseChecker = ccrLicenseChecker;
        this.client = client;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    public RepositoryMetaData getMetadata() {
        return this.metadata;
    }

    public SnapshotInfo getSnapshotInfo(SnapshotId snapshotId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        Client remoteClient = this.client.getRemoteClusterClient(this.remoteClusterAlias);
        ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetaData(true).setNodes(true).get();
        ImmutableOpenMap indicesMap = response.getState().metaData().indices();
        ArrayList indices = new ArrayList(indicesMap.size());
        indicesMap.keysIt().forEachRemaining(indices::add);
        return new SnapshotInfo(snapshotId, indices, SnapshotState.SUCCESS, response.getState().getNodes().getMaxNodeVersion());
    }

    public MetaData getSnapshotGlobalMetaData(SnapshotId snapshotId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        Client remoteClient = this.client.getRemoteClusterClient(this.remoteClusterAlias);
        ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetaData(true).setIndices(new String[]{"dummy_index_name"}).get();
        return response.getState().metaData();
    }

    public IndexMetaData getSnapshotIndexMetaData(SnapshotId snapshotId, IndexId index) throws IOException {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        String leaderIndex = index.getName();
        Client remoteClient = this.client.getRemoteClusterClient(this.remoteClusterAlias);
        ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetaData(true).setIndices(new String[]{leaderIndex}).get();
        PlainActionFuture future = PlainActionFuture.newFuture();
        IndexMetaData leaderIndexMetaData = response.getState().metaData().index(leaderIndex);
        this.ccrLicenseChecker.fetchLeaderHistoryUUIDs(remoteClient, leaderIndexMetaData, arg_0 -> ((PlainActionFuture)future).onFailure(arg_0), arg_0 -> ((PlainActionFuture)future).onResponse(arg_0));
        CharSequence[] leaderHistoryUUIDs = (String[])future.actionGet();
        IndexMetaData.Builder imdBuilder = IndexMetaData.builder((IndexMetaData)leaderIndexMetaData);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("leader_index_shard_history_uuids", String.join((CharSequence)",", leaderHistoryUUIDs));
        metadata.put("leader_index_uuid", leaderIndexMetaData.getIndexUUID());
        metadata.put("leader_index_name", leaderIndexMetaData.getIndex().getName());
        metadata.put("remote_cluster_name", this.remoteClusterAlias);
        imdBuilder.putCustom("ccr", metadata);
        return imdBuilder.build();
    }

    public RepositoryData getRepositoryData() {
        Client remoteClient = this.client.getRemoteClusterClient(this.remoteClusterAlias);
        ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetaData(true).get();
        MetaData remoteMetaData = response.getState().getMetaData();
        HashMap<String, SnapshotId> copiedSnapshotIds = new HashMap<String, SnapshotId>();
        HashMap<String, SnapshotState> snapshotStates = new HashMap<String, SnapshotState>(copiedSnapshotIds.size());
        HashMap<IndexId, Set<SnapshotId>> indexSnapshots = new HashMap<IndexId, Set<SnapshotId>>(copiedSnapshotIds.size());
        ImmutableOpenMap remoteIndices = remoteMetaData.getIndices();
        for (String indexName : remoteMetaData.getConcreteAllIndices()) {
            SnapshotId snapshotId = new SnapshotId(LATEST, LATEST);
            copiedSnapshotIds.put(indexName, snapshotId);
            snapshotStates.put(indexName, SnapshotState.SUCCESS);
            Index index = ((IndexMetaData)remoteIndices.get((Object)indexName)).getIndex();
            indexSnapshots.put(new IndexId(indexName, index.getUUID()), Collections.singleton(snapshotId));
        }
        return new RepositoryData(1L, copiedSnapshotIds, snapshotStates, indexSnapshots, Collections.emptyList());
    }

    public void initializeSnapshot(SnapshotId snapshotId, List<IndexId> indices, MetaData metaData) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public SnapshotInfo finalizeSnapshot(SnapshotId snapshotId, List<IndexId> indices, long startTime, String failure, int totalShards, List<SnapshotShardFailure> shardFailures, long repositoryStateId, boolean includeGlobalState) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void deleteSnapshot(SnapshotId snapshotId, long repositoryStateId) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public long getSnapshotThrottleTimeInNanos() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public long getRestoreThrottleTimeInNanos() {
        return 0L;
    }

    public String startVerification() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void endVerification(String verificationToken) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void verify(String verificationToken, DiscoveryNode localNode) {
    }

    public boolean isReadOnly() {
        return true;
    }

    public void snapshotShard(IndexShard shard, Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, IndexShardSnapshotStatus snapshotStatus) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void restoreShard(IndexShard indexShard, SnapshotId snapshotId, Version version, IndexId indexId, ShardId shardId, RecoveryState recoveryState) {
        Store store = indexShard.store();
        store.incRef();
        try {
            store.createEmpty(indexShard.indexSettings().getIndexMetaData().getCreationVersion().luceneVersion);
        }
        catch (IOException | EngineException e) {
            throw new IndexShardRecoveryException(shardId, "failed to recover from gateway", e);
        }
        finally {
            store.decRef();
        }
    }

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, Version version, IndexId indexId, ShardId shardId) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }
}

