/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.action.ShardFollowNodeTask;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;

public class TransportFollowStatsAction
extends TransportTasksAction<ShardFollowNodeTask, FollowStatsAction.StatsRequest, FollowStatsAction.StatsResponses, FollowStatsAction.StatsResponse> {
    private final CcrLicenseChecker ccrLicenseChecker;

    @Inject
    public TransportFollowStatsAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, CcrLicenseChecker ccrLicenseChecker) {
        super("cluster:monitor/ccr/follow_stats", clusterService, transportService, actionFilters, FollowStatsAction.StatsRequest::new, FollowStatsAction.StatsResponses::new, FollowStatsAction.StatsResponse::new, "ccr");
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
    }

    protected void doExecute(Task task, FollowStatsAction.StatsRequest request, ActionListener<FollowStatsAction.StatsResponses> listener) {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected FollowStatsAction.StatsResponses newResponse(FollowStatsAction.StatsRequest request, List<FollowStatsAction.StatsResponse> statsRespons, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new FollowStatsAction.StatsResponses(taskOperationFailures, failedNodeExceptions, statsRespons);
    }

    protected void processTasks(FollowStatsAction.StatsRequest request, Consumer<ShardFollowNodeTask> operation) {
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetaData persistentTasksMetaData = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
        if (persistentTasksMetaData == null) {
            return;
        }
        HashSet<String> requestedFollowerIndices = request.indices() != null ? new HashSet<String>(Arrays.asList(request.indices())) : Collections.emptySet();
        Set followerIndices = persistentTasksMetaData.tasks().stream().filter(persistentTask -> persistentTask.getTaskName().equals("xpack/ccr/shard_follow_task")).map(persistentTask -> {
            ShardFollowTask shardFollowTask = (ShardFollowTask)persistentTask.getParams();
            return shardFollowTask.getFollowShardId().getIndexName();
        }).filter(followerIndex -> requestedFollowerIndices.isEmpty() || requestedFollowerIndices.contains(followerIndex)).collect(Collectors.toSet());
        for (Task task : this.taskManager.getTasks().values()) {
            ShardFollowNodeTask shardFollowNodeTask;
            if (!(task instanceof ShardFollowNodeTask) || !followerIndices.contains((shardFollowNodeTask = (ShardFollowNodeTask)task).getFollowShardId().getIndexName())) continue;
            operation.accept(shardFollowNodeTask);
        }
    }

    protected void taskOperation(FollowStatsAction.StatsRequest request, ShardFollowNodeTask task, ActionListener<FollowStatsAction.StatsResponse> listener) {
        listener.onResponse((Object)new FollowStatsAction.StatsResponse(task.getStatus()));
    }
}

