/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.util.List;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryRequest;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryRequest;

class CcrRepositoryManager
extends RemoteClusterAware {
    private final Client client;

    CcrRepositoryManager(Settings settings, ClusterService clusterService, Client client) {
        super(settings);
        this.client = client;
        this.listenForUpdates(clusterService.getClusterSettings());
    }

    protected void updateRemoteCluster(String clusterAlias, List<String> addresses, String proxyAddress) {
        String repositoryName = "_ccr_" + clusterAlias;
        if (addresses.isEmpty()) {
            DeleteInternalCcrRepositoryRequest request = new DeleteInternalCcrRepositoryRequest(repositoryName);
            PlainActionFuture f = PlainActionFuture.newFuture();
            this.client.execute((Action)DeleteInternalCcrRepositoryAction.INSTANCE, (ActionRequest)request, (ActionListener)f);
            assert (f.isDone()) : "Should be completed as it is executed synchronously";
        } else {
            PutInternalCcrRepositoryRequest request = new PutInternalCcrRepositoryRequest(repositoryName, "_ccr_");
            PlainActionFuture f = PlainActionFuture.newFuture();
            this.client.execute((Action)PutInternalCcrRepositoryAction.INSTANCE, (ActionRequest)request, (ActionListener)f);
            assert (f.isDone()) : "Should be completed as it is executed synchronously";
        }
    }
}

