/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.proto.Mode;

public class Configuration {
    private final TimeZone timeZone;
    private final int pageSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    private final Mode mode;
    private final String username;
    private final String clusterName;
    private final ZonedDateTime now;
    @Nullable
    private QueryBuilder filter;

    public Configuration(TimeZone tz, int pageSize, TimeValue requestTimeout, TimeValue pageTimeout, QueryBuilder filter, Mode mode, String username, String clusterName) {
        this.timeZone = tz;
        this.pageSize = pageSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.mode = mode == null ? Mode.PLAIN : mode;
        this.username = username;
        this.clusterName = clusterName;
        this.now = ZonedDateTime.now(this.timeZone.toZoneId().normalized());
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public Mode mode() {
        return this.mode;
    }

    public String username() {
        return this.username;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public ZonedDateTime now() {
        return this.now;
    }
}

