/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.Agg;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.PipelineAgg;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class Aggs {
    public static final String ROOT_GROUP_NAME = "groupby";
    public static final GroupByKey IMPLICIT_GROUP_KEY = new GroupByKey("groupby", "", null, null){

        @Override
        public CompositeValuesSourceBuilder<?> createSourceBuilder() {
            throw new SqlIllegalArgumentException("Default group does not translate to an aggregation");
        }

        @Override
        protected GroupByKey copy(String id, String fieldName, ScriptTemplate script, Sort.Direction direction) {
            return this;
        }
    };
    private final List<GroupByKey> groups;
    private final List<LeafAgg> metricAggs;
    private final List<PipelineAgg> pipelineAggs;

    public Aggs() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public Aggs(List<GroupByKey> groups, List<LeafAgg> metricAggs, List<PipelineAgg> pipelineAggs) {
        this.groups = groups;
        this.metricAggs = metricAggs;
        this.pipelineAggs = pipelineAggs;
    }

    public List<GroupByKey> groups() {
        return this.groups;
    }

    public AggregationBuilder asAggBuilder() {
        FiltersAggregationBuilder rootGroup = null;
        if (this.groups.isEmpty() && this.metricAggs.isEmpty()) {
            return null;
        }
        if (!this.groups.isEmpty()) {
            ArrayList keys = new ArrayList(this.groups.size());
            for (GroupByKey key : this.groups) {
                keys.add(key.asValueSource());
            }
            rootGroup = new CompositeAggregationBuilder(ROOT_GROUP_NAME, keys);
        } else {
            rootGroup = new FiltersAggregationBuilder(ROOT_GROUP_NAME, new QueryBuilder[]{QueryBuilders.matchAllQuery()});
        }
        for (LeafAgg leafAgg : this.metricAggs) {
            rootGroup.subAggregation(leafAgg.toBuilder());
        }
        for (PipelineAgg pipelineAgg : this.pipelineAggs) {
            rootGroup.subAggregation(pipelineAgg.toBuilder());
        }
        return rootGroup;
    }

    public boolean useImplicitGroupBy() {
        return this.groups.isEmpty();
    }

    public Aggs addGroups(Collection<GroupByKey> groups) {
        return new Aggs(CollectionUtils.combine(new Collection[]{this.groups, groups}), this.metricAggs, this.pipelineAggs);
    }

    public Aggs addAgg(LeafAgg agg) {
        if (this.metricAggs.contains(agg)) {
            return this;
        }
        return new Aggs(this.groups, CollectionUtils.combine(this.metricAggs, agg), this.pipelineAggs);
    }

    public Aggs addAgg(PipelineAgg pipelineAgg) {
        return new Aggs(this.groups, this.metricAggs, CollectionUtils.combine(this.pipelineAggs, pipelineAgg));
    }

    public GroupByKey findGroupForAgg(String groupOrAggId) {
        for (GroupByKey groupByKey : this.groups) {
            if (!groupOrAggId.equals(groupByKey.id())) continue;
            return groupByKey;
        }
        for (Agg agg : this.metricAggs) {
            if (!groupOrAggId.equals(agg.id())) continue;
            return IMPLICIT_GROUP_KEY;
        }
        return null;
    }

    public Aggs updateGroup(GroupByKey group) {
        ArrayList<GroupByKey> groups = new ArrayList<GroupByKey>(this.groups);
        for (int i = 0; i < groups.size(); ++i) {
            GroupByKey g = (GroupByKey)groups.get(i);
            if (!group.id().equals(g.id())) continue;
            groups.set(i, group);
            return this.with(groups);
        }
        throw new SqlIllegalArgumentException("Could not find group named {}", group.id());
    }

    public Aggs with(List<GroupByKey> groups) {
        return new Aggs(groups, this.metricAggs, this.pipelineAggs);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.metricAggs, this.pipelineAggs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Aggs other = (Aggs)obj;
        return Objects.equals(this.groups, other.groups) && Objects.equals(this.metricAggs, other.metricAggs) && Objects.equals(this.pipelineAggs, other.pipelineAggs);
    }
}

