/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.comparison;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparisonPipe;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Comparisons;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class BinaryComparison
extends BinaryOperator<Object, Object, Boolean, BinaryComparisonProcessor.BinaryComparisonOperation> {
    protected BinaryComparison(Location location, Expression left, Expression right, BinaryComparisonProcessor.BinaryComparisonOperation operation) {
        super(location, left, right, operation);
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, Expressions.ParamOrdinal paramOrdinal) {
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    protected Expression canonicalize() {
        return this.left().hashCode() > this.right().hashCode() ? this.swapLeftAndRight() : this;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryComparisonPipe(this.location(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), (BinaryComparisonProcessor.BinaryComparisonOperation)this.function());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left());
        sb.append(" ");
        sb.append(this.symbol());
        sb.append(" ");
        sb.append(this.right());
        return sb.toString();
    }

    public static Integer compare(Object left, Object right) {
        return Comparisons.compare(left, right);
    }
}

