/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class Mul
extends ArithmeticOperation {
    private DataType dataType;

    public Mul(Location location, Expression left, Expression right) {
        super(location, left, right, BinaryArithmeticProcessor.BinaryArithmeticOperation.MUL);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        DataType l = this.left().dataType();
        DataType r = this.right().dataType();
        if (l.isNumeric() && r.isNumeric()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (DataTypes.isInterval(l) && r.isInteger()) {
            this.dataType = l;
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (DataTypes.isInterval(r) && l.isInteger()) {
            this.dataType = r;
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(LoggerMessageFormat.format((String)"[{}] has arguments with incompatible types [{}] and [{}]", (String)this.symbol(), (Object[])new Object[]{l, r}));
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = super.dataType();
        }
        return this.dataType;
    }

    @Override
    protected NodeInfo<Mul> info() {
        return NodeInfo.create(this, Mul::new, this.left(), this.right());
    }

    @Override
    protected Mul replaceChildren(Expression newLeft, Expression newRight) {
        return new Mul(this.location(), newLeft, newRight);
    }
}

