/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.QuarterProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Quarter
extends BaseDateTimeFunction {
    public Quarter(Location location, Expression field, TimeZone timeZone) {
        super(location, field, timeZone);
    }

    @Override
    protected Object doFold(ZonedDateTime dateTime) {
        return QuarterProcessor.quarter(dateTime);
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.formatTemplate("{sql}.quarter(doc[{}].value, {})"), ParamsBuilder.paramsBuilder().variable(field.name()).variable(this.timeZone().getID()).build(), this.dataType());
    }

    @Override
    protected NodeInfo.NodeCtor2<Expression, TimeZone, BaseDateTimeFunction> ctorForInfo() {
        return Quarter::new;
    }

    @Override
    protected Quarter replaceChild(Expression newChild) {
        return new Quarter(this.location(), newChild, this.timeZone());
    }

    @Override
    protected Processor makeProcessor() {
        return new QuarterProcessor(this.timeZone());
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }
}

