/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public abstract class BaseDateTimeProcessor
implements Processor {
    private final TimeZone timeZone;
    private final ZoneId zoneId;

    BaseDateTimeProcessor(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.zoneId = timeZone.toZoneId();
    }

    BaseDateTimeProcessor(StreamInput in) throws IOException {
        this.timeZone = TimeZone.getTimeZone(in.readString());
        this.zoneId = this.timeZone.toZoneId();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.timeZone.getID());
    }

    TimeZone timeZone() {
        return this.timeZone;
    }

    @Override
    public Object process(Object input) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof ZonedDateTime)) {
            throw new SqlIllegalArgumentException("A date is required; received {}", input);
        }
        return this.doProcess(((ZonedDateTime)input).withZoneSameInstant(this.zoneId));
    }

    abstract Object doProcess(ZonedDateTime var1);
}

