/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.grouping;

import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class Histogram
extends GroupingFunction {
    private final Literal interval;
    private final TimeZone timeZone;

    public Histogram(Location location, Expression field, Expression interval, TimeZone timeZone) {
        super(location, field);
        this.interval = (Literal)interval;
        this.timeZone = timeZone;
    }

    public Literal interval() {
        return this.interval;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = Expressions.typeMustBeNumericOrDate(this.field(), "HISTOGRAM", Expressions.ParamOrdinal.FIRST);
        if (resolution == Expression.TypeResolution.TYPE_RESOLVED) {
            resolution = this.field().dataType() == DataType.DATE ? Expressions.typeMustBe(this.interval, DataTypes::isInterval, "(Date) HISTOGRAM", Expressions.ParamOrdinal.SECOND, "interval") : Expressions.typeMustBeNumeric(this.interval, "(Numeric) HISTOGRAM", Expressions.ParamOrdinal.SECOND);
        }
        return resolution;
    }

    @Override
    protected GroupingFunction replaceChild(Expression newChild) {
        return new Histogram(this.location(), newChild, this.interval, this.timeZone);
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Histogram::new, this.field(), this.interval, this.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.interval, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Histogram other = (Histogram)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.timeZone, other.timeZone);
        }
        return false;
    }
}

