/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.grouping;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.grouping.GroupingFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.AggNameInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public abstract class GroupingFunction
extends Function {
    private final Expression field;
    private final List<Expression> parameters;
    private GroupingFunctionAttribute lazyAttribute;

    protected GroupingFunction(Location location, Expression field) {
        this(location, field, Collections.emptyList());
    }

    protected GroupingFunction(Location location, Expression field, List<Expression> parameters) {
        super(location, CollectionUtils.combine(Collections.singletonList(field), parameters));
        this.field = field;
        this.parameters = parameters;
    }

    public Expression field() {
        return this.field;
    }

    public List<Expression> parameters() {
        return this.parameters;
    }

    @Override
    public GroupingFunctionAttribute toAttribute() {
        if (this.lazyAttribute == null) {
            this.lazyAttribute = new GroupingFunctionAttribute(this.location(), this.name(), this.dataType(), this.id(), this.functionId());
        }
        return this.lazyAttribute;
    }

    @Override
    public final GroupingFunction replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return this.replaceChild(newChildren.get(0));
    }

    protected abstract GroupingFunction replaceChild(Expression var1);

    @Override
    protected Pipe makePipe() {
        return new AggNameInput(this.location(), (Expression)this, this.name());
    }

    @Override
    public ScriptTemplate asScript() {
        throw new SqlIllegalArgumentException("Grouping functions cannot be scripted");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GroupingFunction other = (GroupingFunction)obj;
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.parameters(), this.parameters());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.parameters());
    }
}

