/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.capabilities.UnresolvedException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.sql.expression.UnresolvedNamedExpression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class UnresolvedStar
extends UnresolvedNamedExpression {
    private final UnresolvedAttribute qualifier;

    public UnresolvedStar(Location location, UnresolvedAttribute qualifier) {
        super(location, Collections.emptyList());
        this.qualifier = qualifier;
    }

    @Override
    protected NodeInfo<UnresolvedStar> info() {
        return NodeInfo.create(this, UnresolvedStar::new, this.qualifier);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    @Override
    public boolean nullable() {
        throw new UnresolvedException("nullable", (Object)this);
    }

    public UnresolvedAttribute qualifier() {
        return this.qualifier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.qualifier);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnresolvedStar other = (UnresolvedStar)obj;
        return Objects.equals(this.qualifier, other.qualifier);
    }

    private String message() {
        return (this.qualifier() != null ? this.qualifier().qualifiedName() + "." : "") + "*";
    }

    @Override
    public String unresolvedMessage() {
        return "Cannot determine columns for [" + this.message() + "]";
    }

    @Override
    public String toString() {
        return "?" + this.message();
    }
}

