/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.execution.search.SearchHitRowSet;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.RowSet;

public class ScrollCursor
implements Cursor {
    private final Logger log = LogManager.getLogger(this.getClass());
    public static final String NAME = "s";
    private final String scrollId;
    private final List<HitExtractor> extractors;
    private final int limit;

    public ScrollCursor(String scrollId, List<HitExtractor> extractors, int limit) {
        this.scrollId = scrollId;
        this.extractors = extractors;
        this.limit = limit;
    }

    public ScrollCursor(StreamInput in) throws IOException {
        this.scrollId = in.readString();
        this.limit = in.readVInt();
        this.extractors = in.readNamedWriteableList(HitExtractor.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.scrollId);
        out.writeVInt(this.limit);
        out.writeNamedWriteableList(this.extractors);
    }

    public String getWriteableName() {
        return NAME;
    }

    String scrollId() {
        return this.scrollId;
    }

    List<HitExtractor> extractors() {
        return this.extractors;
    }

    int limit() {
        return this.limit;
    }

    @Override
    public void nextPage(Configuration cfg, Client client, NamedWriteableRegistry registry, ActionListener<RowSet> listener) {
        this.log.trace("About to execute scroll query {}", (Object)this.scrollId);
        SearchScrollRequest request = new SearchScrollRequest(this.scrollId).scroll(cfg.pageTimeout());
        client.searchScroll(request, ActionListener.wrap(response -> {
            SearchHitRowSet rowSet = new SearchHitRowSet(this.extractors, response.getHits().getHits(), this.limit, response.getScrollId());
            if (rowSet.nextPageCursor() == Cursor.EMPTY) {
                this.clear(cfg, client, (ActionListener<Boolean>)ActionListener.wrap(success -> listener.onResponse((Object)rowSet), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)rowSet);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void clear(Configuration cfg, Client client, ActionListener<Boolean> listener) {
        ScrollCursor.cleanCursor(client, this.scrollId, (ActionListener<ClearScrollResponse>)ActionListener.wrap(clearScrollResponse -> listener.onResponse((Object)clearScrollResponse.isSucceeded()), arg_0 -> listener.onFailure(arg_0)));
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ScrollCursor other = (ScrollCursor)obj;
        return Objects.equals(this.scrollId, other.scrollId) && Objects.equals(this.extractors, other.extractors) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.scrollId, this.extractors, this.limit);
    }

    public String toString() {
        return "cursor for scroll [" + this.scrollId + "]";
    }

    public static void cleanCursor(Client client, String scrollId, ActionListener<ClearScrollResponse> listener) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        client.clearScroll(clearScrollRequest, listener);
    }
}

