/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.InMemoryDirectoryServerPassword;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.InMemorySASLBindHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.RequestControlPreProcessor;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityResponseControl;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PLAINBindHandler
extends InMemorySASLBindHandler {
    @Override
    public String getSASLMechanismName() {
        return "PLAIN";
    }

    @Override
    public BindResult processSASLBind(InMemoryRequestHandler handler, int messageID, DN bindDN, ASN1OctetString credentials, List<Control> controls) {
        boolean passwordValid;
        DN authDN;
        Map<String, Control> controlMap;
        try {
            controlMap = RequestControlPreProcessor.processControls((byte)96, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new BindResult(messageID, le.getResultCode(), le.getMessage(), le.getMatchedDN(), le.getReferralURLs(), le.getResponseControls());
        }
        if (credentials == null) {
            return new BindResult(messageID, ResultCode.INVALID_CREDENTIALS, ListenerMessages.ERR_PLAIN_BIND_NO_CREDENTIALS.get(), null, null, null);
        }
        int firstNullPos = -1;
        int secondNullPos = -1;
        byte[] credBytes = credentials.getValue();
        for (int i = 0; i < credBytes.length; ++i) {
            if (credBytes[i] != 0) continue;
            if (firstNullPos < 0) {
                firstNullPos = i;
                continue;
            }
            secondNullPos = i;
            break;
        }
        if (secondNullPos < 0) {
            return new BindResult(messageID, ResultCode.INVALID_CREDENTIALS, ListenerMessages.ERR_PLAIN_BIND_MALFORMED_CREDENTIALS.get(), null, null, null);
        }
        String authcID = StaticUtils.toUTF8String(credBytes, firstNullPos + 1, secondNullPos - firstNullPos - 1);
        String authzID = firstNullPos == 0 ? null : StaticUtils.toUTF8String(credBytes, 0, firstNullPos);
        try {
            authDN = handler.getDNForAuthzID(authcID);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new BindResult(messageID, ResultCode.INVALID_CREDENTIALS, le.getMessage(), le.getMatchedDN(), le.getReferralURLs(), le.getResponseControls());
        }
        byte[] bindPWBytes = new byte[credBytes.length - secondNullPos - 1];
        System.arraycopy(credBytes, secondNullPos + 1, bindPWBytes, 0, bindPWBytes.length);
        if (authDN.isNullDN()) {
            passwordValid = bindPWBytes.length == 0 && authzID == null;
        } else {
            ReadOnlyEntry authEntry = handler.getEntry(authDN);
            if (authEntry == null) {
                byte[] userPWBytes = handler.getAdditionalBindCredentials(authDN);
                passwordValid = Arrays.equals(bindPWBytes, userPWBytes);
            } else {
                List<InMemoryDirectoryServerPassword> passwordList = handler.getPasswordsInEntry(authEntry, new ASN1OctetString(bindPWBytes));
                boolean bl = passwordValid = !passwordList.isEmpty();
            }
        }
        if (!passwordValid) {
            return new BindResult(messageID, ResultCode.INVALID_CREDENTIALS, null, null, null, null);
        }
        if (authzID != null) {
            try {
                authDN = handler.getDNForAuthzID(authzID);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new BindResult(messageID, ResultCode.INVALID_CREDENTIALS, le.getMessage(), le.getMatchedDN(), le.getReferralURLs(), le.getResponseControls());
            }
        }
        handler.setAuthenticatedDN(authDN);
        Control[] responseControls = controlMap.containsKey("2.16.840.1.113730.3.4.16") ? (authDN == null ? new Control[]{new AuthorizationIdentityResponseControl("")} : new Control[]{new AuthorizationIdentityResponseControl("dn:" + authDN.toString())}) : null;
        return new BindResult(messageID, ResultCode.SUCCESS, null, null, null, responseControls);
    }
}

