/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class FeatureFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "feature";

    private FeatureFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
    }

    protected FeatureFieldMapper clone() {
        return (FeatureFieldMapper)super.clone();
    }

    public FeatureFieldType fieldType() {
        return (FeatureFieldType)super.fieldType();
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        float value;
        if (context.externalValueSet()) {
            Object v = context.externalValue();
            value = v instanceof Number ? ((Number)v).floatValue() : Float.parseFloat(v.toString());
        } else {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().floatValue();
        }
        if (context.doc().getByKey((Object)this.name()) != null) {
            throw new IllegalArgumentException("[feature] fields do not support indexing multiple values for the same field [" + this.name() + "] in the same document");
        }
        if (!this.fieldType().positiveScoreImpact()) {
            value = 1.0f / value;
        }
        context.doc().addWithKey((Object)this.name(), (IndexableField)new FeatureField("_feature", this.name(), value));
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || !this.fieldType().positiveScoreImpact()) {
            builder.field("positive_score_impact", this.fieldType().positiveScoreImpact());
        }
    }

    public static final class FeatureFieldType
    extends MappedFieldType {
        private boolean positiveScoreImpact = true;

        public FeatureFieldType() {
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        protected FeatureFieldType(FeatureFieldType ref) {
            super((MappedFieldType)ref);
            this.positiveScoreImpact = ref.positiveScoreImpact;
        }

        public FeatureFieldType clone() {
            return new FeatureFieldType(this);
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            FeatureFieldType other = (FeatureFieldType)((Object)o);
            return Objects.equals(this.positiveScoreImpact, other.positiveScoreImpact);
        }

        public int hashCode() {
            int h = super.hashCode();
            h = 31 * h + Objects.hashCode(this.positiveScoreImpact);
            return h;
        }

        public void checkCompatibility(MappedFieldType other, List<String> conflicts) {
            super.checkCompatibility(other, conflicts);
            if (this.positiveScoreImpact != ((FeatureFieldType)other).positiveScoreImpact()) {
                conflicts.add("mapper [" + this.name() + "] has different [positive_score_impact] values");
            }
        }

        public String typeName() {
            return FeatureFieldMapper.CONTENT_TYPE;
        }

        public boolean positiveScoreImpact() {
            return this.positiveScoreImpact;
        }

        public void setPositiveScoreImpact(boolean positiveScoreImpact) {
            this.checkIfFrozen();
            this.positiveScoreImpact = positiveScoreImpact;
        }

        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_feature", this.name()));
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            throw new UnsupportedOperationException("[feature] fields do not support sorting, scripting or aggregating");
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Queries on [feature] fields are not supported");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!propName.equals("positive_score_impact")) continue;
                builder.positiveScoreImpact(XContentMapValues.nodeBooleanValue((Object)propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, FeatureFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public FeatureFieldType fieldType() {
            return (FeatureFieldType)super.fieldType();
        }

        public Builder positiveScoreImpact(boolean v) {
            this.fieldType().setPositiveScoreImpact(v);
            return (Builder)this.builder;
        }

        public FeatureFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new FeatureFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new FeatureFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

