/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.nio.HttpReadWriteHandler;
import org.elasticsearch.http.nio.NioHttpChannel;
import org.elasticsearch.http.nio.NioHttpServerChannel;
import org.elasticsearch.http.nio.NioHttpServerTransport;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.ReadWriteHandler;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.transport.SecurityHttpExceptionHandler;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.nio.NioIPFilter;
import org.elasticsearch.xpack.security.transport.nio.SSLChannelContext;
import org.elasticsearch.xpack.security.transport.nio.SSLDriver;

public class SecurityNioHttpServerTransport
extends NioHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(SecurityNioHttpServerTransport.class);
    private final SecurityHttpExceptionHandler securityExceptionHandler;
    private final IPFilter ipFilter;
    private final NioIPFilter nioIpFilter;
    private final SSLService sslService;
    private final SSLConfiguration sslConfiguration;
    private final boolean sslEnabled;

    public SecurityNioHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, IPFilter ipFilter, SSLService sslService) {
        super(settings, networkService, bigArrays, pageCacheRecycler, threadPool, xContentRegistry, dispatcher);
        this.securityExceptionHandler = new SecurityHttpExceptionHandler(logger, this.lifecycle, (c, e) -> super.onException(c, e));
        this.ipFilter = ipFilter;
        this.nioIpFilter = new NioIPFilter(ipFilter, ".http");
        this.sslEnabled = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
        this.sslService = sslService;
        if (this.sslEnabled) {
            this.sslConfiguration = sslService.getHttpTransportSSLConfiguration();
            if (!sslService.isConfigurationValidForServerUsage(this.sslConfiguration)) {
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.http.ssl.key] or [xpack.security.http.ssl.keystore.path] setting");
            }
        } else {
            this.sslConfiguration = null;
        }
    }

    protected void doStart() {
        super.doStart();
        this.ipFilter.setBoundHttpTransportAddress(this.boundAddress());
    }

    protected SecurityHttpChannelFactory channelFactory() {
        return new SecurityHttpChannelFactory();
    }

    class SecurityHttpChannelFactory
    extends ChannelFactory<NioHttpServerChannel, NioHttpChannel> {
        private SecurityHttpChannelFactory() {
            super(new ChannelFactory.RawChannelFactory(SecurityNioHttpServerTransport.this.tcpNoDelay, SecurityNioHttpServerTransport.this.tcpKeepAlive, SecurityNioHttpServerTransport.this.reuseAddress, SecurityNioHttpServerTransport.this.tcpSendBufferSize, SecurityNioHttpServerTransport.this.tcpReceiveBufferSize));
        }

        public NioHttpChannel createChannel(NioSelector selector, SocketChannel channel) throws IOException {
            Object context;
            NioHttpChannel httpChannel = new NioHttpChannel(channel);
            Supplier<InboundChannelBuffer.Page> pageSupplier = () -> {
                Recycler.V bytes = SecurityNioHttpServerTransport.this.pageCacheRecycler.bytePage(false);
                return new InboundChannelBuffer.Page(ByteBuffer.wrap((byte[])bytes.v()), () -> ((Recycler.V)bytes).close());
            };
            HttpReadWriteHandler httpHandler = new HttpReadWriteHandler(httpChannel, (NioHttpServerTransport)SecurityNioHttpServerTransport.this, SecurityNioHttpServerTransport.this.handlingSettings, SecurityNioHttpServerTransport.this.corsConfig);
            InboundChannelBuffer buffer = new InboundChannelBuffer(pageSupplier);
            Consumer<Exception> exceptionHandler = e -> SecurityNioHttpServerTransport.this.securityExceptionHandler.accept((HttpChannel)httpChannel, (Exception)e);
            if (SecurityNioHttpServerTransport.this.sslEnabled) {
                SSLEngine sslEngine;
                boolean hostnameVerificationEnabled = SecurityNioHttpServerTransport.this.sslConfiguration.verificationMode().isHostnameVerificationEnabled();
                if (hostnameVerificationEnabled) {
                    InetSocketAddress address = (InetSocketAddress)channel.getRemoteAddress();
                    sslEngine = SecurityNioHttpServerTransport.this.sslService.createSSLEngine(SecurityNioHttpServerTransport.this.sslConfiguration, address.getHostString(), address.getPort());
                } else {
                    sslEngine = SecurityNioHttpServerTransport.this.sslService.createSSLEngine(SecurityNioHttpServerTransport.this.sslConfiguration, null, -1);
                }
                SSLDriver sslDriver = new SSLDriver(sslEngine, false);
                context = new SSLChannelContext((NioSocketChannel)httpChannel, selector, exceptionHandler, sslDriver, (ReadWriteHandler)httpHandler, buffer, SecurityNioHttpServerTransport.this.nioIpFilter);
            } else {
                context = new BytesChannelContext((NioSocketChannel)httpChannel, selector, exceptionHandler, (ReadWriteHandler)httpHandler, buffer, (Predicate)SecurityNioHttpServerTransport.this.nioIpFilter);
            }
            httpChannel.setContext((SocketChannelContext)context);
            return httpChannel;
        }

        public NioHttpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel) {
            NioHttpServerChannel httpServerChannel = new NioHttpServerChannel(channel);
            Consumer<Exception> exceptionHandler = e -> SecurityNioHttpServerTransport.this.onServerException((HttpServerChannel)httpServerChannel, e);
            Consumer<NioSocketChannel> acceptor = x$0 -> SecurityNioHttpServerTransport.this.acceptChannel(x$0);
            ServerChannelContext context = new ServerChannelContext((NioServerSocketChannel)httpServerChannel, (ChannelFactory)this, selector, acceptor, exceptionHandler);
            httpServerChannel.setContext(context);
            return httpServerChannel;
        }
    }
}

