/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.protocol.xpack.graph.GraphExploreRequest;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.authz.AuthorizedIndices;

class IndicesAndAliasesResolver {
    static final String[] NO_INDICES_OR_ALIASES_ARRAY = new String[]{"*", "-*"};
    static final List<String> NO_INDICES_OR_ALIASES_LIST = Arrays.asList(NO_INDICES_OR_ALIASES_ARRAY);
    private final IndexNameExpressionResolver nameExpressionResolver = new IndexNameExpressionResolver();
    private final RemoteClusterResolver remoteClusterResolver;

    IndicesAndAliasesResolver(Settings settings, ClusterService clusterService) {
        this.remoteClusterResolver = new RemoteClusterResolver(settings, clusterService.getClusterSettings());
    }

    ResolvedIndices resolve(TransportRequest request, MetaData metaData, AuthorizedIndices authorizedIndices) {
        if (request instanceof IndicesAliasesRequest) {
            ResolvedIndices.Builder resolvedIndicesBuilder = new ResolvedIndices.Builder();
            IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)request;
            for (IndicesRequest indicesRequest : indicesAliasesRequest.getAliasActions()) {
                ResolvedIndices resolved = this.resolveIndicesAndAliases(indicesRequest, metaData, authorizedIndices);
                resolvedIndicesBuilder.addLocal(resolved.getLocal());
                resolvedIndicesBuilder.addRemote(resolved.getRemote());
            }
            return resolvedIndicesBuilder.build();
        }
        if (!(request instanceof IndicesRequest)) {
            throw new IllegalStateException("Request [" + request + "] is not an Indices request, but should be.");
        }
        return this.resolveIndicesAndAliases((IndicesRequest)request, metaData, authorizedIndices);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ResolvedIndices resolveIndicesAndAliases(IndicesRequest indicesRequest, MetaData metaData, AuthorizedIndices authorizedIndices) {
        ResolvedIndices.Builder resolvedIndicesBuilder = new ResolvedIndices.Builder();
        boolean indicesReplacedWithNoIndices = false;
        if (indicesRequest instanceof PutMappingRequest && ((PutMappingRequest)indicesRequest).getConcreteIndex() != null) {
            assert (indicesRequest.indices() == null || indicesRequest.indices().length == 0) : "indices are: " + Arrays.toString(indicesRequest.indices());
            resolvedIndicesBuilder.addLocal(IndicesAndAliasesResolver.getPutMappingIndexOrAlias((PutMappingRequest)indicesRequest, authorizedIndices, metaData));
        } else if (indicesRequest instanceof IndicesRequest.Replaceable) {
            String[] replaceable = (String[])indicesRequest;
            int replaceWildcards = indicesRequest.indicesOptions().expandWildcardsOpen() || indicesRequest.indicesOptions().expandWildcardsClosed() ? 1 : 0;
            IndicesOptions indicesOptions = indicesRequest.indicesOptions();
            if (indicesRequest instanceof IndicesExistsRequest) {
                indicesOptions = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)indicesOptions.expandWildcardsOpen(), (boolean)indicesOptions.expandWildcardsClosed());
            }
            if (IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
                if (replaceWildcards) {
                    for (String string : authorizedIndices.get()) {
                        if (!IndicesAndAliasesResolver.isIndexVisible(string, indicesOptions, metaData)) continue;
                        resolvedIndicesBuilder.addLocal(string);
                    }
                }
            } else {
                void var10_17;
                ResolvedIndices split = IndicesAndAliasesResolver.allowsRemoteIndices(indicesRequest) ? this.remoteClusterResolver.splitLocalAndRemoteIndexNames(indicesRequest.indices()) : new ResolvedIndices(Arrays.asList(indicesRequest.indices()), Collections.emptyList());
                List<String> list = this.replaceWildcardsWithAuthorizedIndices(split.getLocal(), indicesOptions, metaData, authorizedIndices.get(), replaceWildcards != 0);
                if (indicesOptions.ignoreUnavailable()) {
                    List list2 = list.stream().filter(authorizedIndices.get()::contains).collect(Collectors.toList());
                }
                resolvedIndicesBuilder.addLocal((List)var10_17);
                resolvedIndicesBuilder.addRemote(split.getRemote());
            }
            if (resolvedIndicesBuilder.isEmpty()) {
                if (!indicesOptions.allowNoIndices()) throw new IndexNotFoundException(Arrays.toString(indicesRequest.indices()));
                replaceable.indices(NO_INDICES_OR_ALIASES_ARRAY);
                indicesReplacedWithNoIndices = true;
                resolvedIndicesBuilder.addLocal("-*");
            } else {
                replaceable.indices(resolvedIndicesBuilder.build().toArray());
            }
        } else {
            if (this.containsWildcards(indicesRequest)) {
                throw new IllegalStateException("There are no external requests known to support wildcards that don't support replacing their indices");
            }
            for (String name : indicesRequest.indices()) {
                resolvedIndicesBuilder.addLocal(this.nameExpressionResolver.resolveDateMathExpression(name));
            }
        }
        if (!(indicesRequest instanceof AliasesRequest)) return resolvedIndicesBuilder.build();
        AliasesRequest aliasesRequest = (AliasesRequest)indicesRequest;
        if (aliasesRequest.expandAliasesWildcards()) {
            List<String> aliases = this.replaceWildcardsWithAuthorizedAliases(aliasesRequest.aliases(), this.loadAuthorizedAliases(authorizedIndices.get(), metaData));
            aliasesRequest.replaceAliases(aliases.toArray(new String[aliases.size()]));
        }
        if (indicesReplacedWithNoIndices) {
            if (!(indicesRequest instanceof GetAliasesRequest)) {
                throw new IllegalStateException(GetAliasesRequest.class.getSimpleName() + " is the only known request implementing " + AliasesRequest.class.getSimpleName() + " that may allow no indices. Found [" + indicesRequest.getClass().getName() + "] which ended up with an empty set of indices.");
            }
        } else {
            resolvedIndicesBuilder.addLocal(aliasesRequest.aliases());
        }
        if (aliasesRequest.aliases().length != 0) return resolvedIndicesBuilder.build();
        aliasesRequest.replaceAliases(NO_INDICES_OR_ALIASES_ARRAY);
        return resolvedIndicesBuilder.build();
    }

    static String getPutMappingIndexOrAlias(PutMappingRequest request, AuthorizedIndices authorizedIndices, MetaData metaData) {
        String resolvedAliasOrIndex;
        String concreteIndexName = request.getConcreteIndex().getName();
        List<String> authorizedIndicesList = authorizedIndices.get();
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(concreteIndexName);
        if (aliasOrIndex == null) {
            resolvedAliasOrIndex = concreteIndexName;
        } else {
            if (aliasOrIndex.isAlias()) {
                throw new IllegalStateException("concrete index [" + concreteIndexName + "] is an alias but should not be");
            }
            if (authorizedIndicesList.contains(concreteIndexName)) {
                resolvedAliasOrIndex = concreteIndexName;
            } else {
                ImmutableOpenMap foundAliases = metaData.findAllAliases(new String[]{concreteIndexName});
                List aliasMetaData = (List)foundAliases.get((Object)concreteIndexName);
                if (aliasMetaData != null) {
                    Optional<String> foundAlias = aliasMetaData.stream().map(AliasMetaData::alias).filter(authorizedIndicesList::contains).filter(aliasName -> ((AliasOrIndex)metaData.getAliasAndIndexLookup().get(aliasName)).getIndices().size() == 1).findFirst();
                    resolvedAliasOrIndex = foundAlias.orElse(concreteIndexName);
                } else {
                    resolvedAliasOrIndex = concreteIndexName;
                }
            }
        }
        return resolvedAliasOrIndex;
    }

    static boolean allowsRemoteIndices(IndicesRequest request) {
        return request instanceof SearchRequest || request instanceof FieldCapabilitiesRequest || request instanceof GraphExploreRequest;
    }

    private List<String> loadAuthorizedAliases(List<String> authorizedIndices, MetaData metaData) {
        ArrayList<String> authorizedAliases = new ArrayList<String>();
        SortedMap existingAliases = metaData.getAliasAndIndexLookup();
        for (String authorizedIndex : authorizedIndices) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)existingAliases.get(authorizedIndex);
            if (aliasOrIndex == null || !aliasOrIndex.isAlias()) continue;
            authorizedAliases.add(authorizedIndex);
        }
        return authorizedAliases;
    }

    private List<String> replaceWildcardsWithAuthorizedAliases(String[] aliases, List<String> authorizedAliases) {
        ArrayList<String> finalAliases = new ArrayList<String>();
        if (aliases.length == 0) {
            finalAliases.addAll(authorizedAliases);
        }
        for (String aliasExpression : aliases) {
            boolean include = true;
            if (aliasExpression.charAt(0) == '-') {
                include = false;
                aliasExpression = aliasExpression.substring(1);
            }
            if ("_all".equals(aliasExpression) || Regex.isSimpleMatchPattern((String)aliasExpression)) {
                HashSet<String> resolvedAliases = new HashSet<String>();
                for (String authorizedAlias : authorizedAliases) {
                    if (!"_all".equals(aliasExpression) && !Regex.simpleMatch((String)aliasExpression, (String)authorizedAlias)) continue;
                    resolvedAliases.add(authorizedAlias);
                }
                if (include) {
                    finalAliases.addAll(resolvedAliases);
                    continue;
                }
                finalAliases.removeAll(resolvedAliases);
                continue;
            }
            if (include) {
                finalAliases.add(aliasExpression);
                continue;
            }
            finalAliases.remove(aliasExpression);
        }
        return finalAliases;
    }

    private boolean containsWildcards(IndicesRequest indicesRequest) {
        if (IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
            return true;
        }
        for (String index : indicesRequest.indices()) {
            if (!Regex.isSimpleMatchPattern((String)index)) continue;
            return true;
        }
        return false;
    }

    private List<String> replaceWildcardsWithAuthorizedIndices(Iterable<String> indices, IndicesOptions indicesOptions, MetaData metaData, List<String> authorizedIndices, boolean replaceWildcards) {
        ArrayList<String> finalIndices = new ArrayList<String>();
        boolean wildcardSeen = false;
        for (String index : indices) {
            String aliasOrIndex;
            boolean minus = false;
            if (index.charAt(0) == '-' && wildcardSeen) {
                aliasOrIndex = index.substring(1);
                minus = true;
            } else {
                aliasOrIndex = index;
            }
            String dateMathName = this.nameExpressionResolver.resolveDateMathExpression(aliasOrIndex);
            if (dateMathName != aliasOrIndex) {
                assert (!dateMathName.equals(aliasOrIndex));
                if (replaceWildcards && Regex.isSimpleMatchPattern((String)dateMathName)) {
                    aliasOrIndex = dateMathName;
                } else if (authorizedIndices.contains(dateMathName) && IndicesAndAliasesResolver.isIndexVisible(dateMathName, indicesOptions, metaData, true)) {
                    if (minus) {
                        finalIndices.remove(dateMathName);
                    } else {
                        finalIndices.add(dateMathName);
                    }
                } else if (!indicesOptions.ignoreUnavailable()) {
                    throw new IndexNotFoundException(dateMathName);
                }
            }
            if (replaceWildcards && Regex.isSimpleMatchPattern((String)aliasOrIndex)) {
                wildcardSeen = true;
                HashSet<String> resolvedIndices = new HashSet<String>();
                for (String authorizedIndex : authorizedIndices) {
                    if (!Regex.simpleMatch((String)aliasOrIndex, (String)authorizedIndex) || !IndicesAndAliasesResolver.isIndexVisible(authorizedIndex, indicesOptions, metaData)) continue;
                    resolvedIndices.add(authorizedIndex);
                }
                if (resolvedIndices.isEmpty()) {
                    if (indicesOptions.allowNoIndices()) continue;
                    throw new IndexNotFoundException(aliasOrIndex);
                }
                if (minus) {
                    finalIndices.removeAll(resolvedIndices);
                    continue;
                }
                finalIndices.addAll(resolvedIndices);
                continue;
            }
            if (dateMathName != aliasOrIndex) continue;
            assert (dateMathName.equals(aliasOrIndex));
            if (minus) {
                finalIndices.remove(aliasOrIndex);
                continue;
            }
            finalIndices.add(aliasOrIndex);
        }
        return finalIndices;
    }

    private static boolean isIndexVisible(String index, IndicesOptions indicesOptions, MetaData metaData) {
        return IndicesAndAliasesResolver.isIndexVisible(index, indicesOptions, metaData, false);
    }

    private static boolean isIndexVisible(String index, IndicesOptions indicesOptions, MetaData metaData, boolean dateMathExpression) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(index);
        if (aliasOrIndex.isAlias()) {
            return !indicesOptions.ignoreAliases();
        }
        assert (aliasOrIndex.getIndices().size() == 1) : "concrete index must point to a single index";
        IndexMetaData indexMetaData = (IndexMetaData)aliasOrIndex.getIndices().get(0);
        if (indexMetaData.getState() == IndexMetaData.State.CLOSE && (indicesOptions.expandWildcardsClosed() || dateMathExpression)) {
            return true;
        }
        return indexMetaData.getState() == IndexMetaData.State.OPEN && (indicesOptions.expandWildcardsOpen() || dateMathExpression);
    }

    private static List<String> indicesList(String[] list) {
        return list == null ? null : Arrays.asList(list);
    }

    public static class ResolvedIndices {
        private final List<String> local;
        private final List<String> remote;

        ResolvedIndices(List<String> local, List<String> remote) {
            this.local = Collections.unmodifiableList(local);
            this.remote = Collections.unmodifiableList(remote);
        }

        public List<String> getLocal() {
            return this.local;
        }

        public List<String> getRemote() {
            return this.remote;
        }

        public boolean isEmpty() {
            return this.local.isEmpty() && this.remote.isEmpty();
        }

        public boolean isNoIndicesPlaceholder() {
            return this.remote.isEmpty() && this.local.size() == 1 && this.local.contains("-*");
        }

        private String[] toArray() {
            String[] array = new String[this.local.size() + this.remote.size()];
            int i = 0;
            for (String index : this.local) {
                array[i++] = index;
            }
            for (String index : this.remote) {
                array[i++] = index;
            }
            return array;
        }

        private static class Builder {
            private final List<String> local = new ArrayList<String>();
            private final List<String> remote = new ArrayList<String>();

            private Builder() {
            }

            private void addLocal(String index) {
                this.local.add(index);
            }

            private void addLocal(String[] indices) {
                this.local.addAll(Arrays.asList(indices));
            }

            private void addLocal(List<String> indices) {
                this.local.addAll(indices);
            }

            private void addRemote(List<String> indices) {
                this.remote.addAll(indices);
            }

            private boolean isEmpty() {
                return this.local.isEmpty() && this.remote.isEmpty();
            }

            private ResolvedIndices build() {
                return new ResolvedIndices(this.local, this.remote);
            }
        }
    }

    private static class RemoteClusterResolver
    extends RemoteClusterAware {
        private final CopyOnWriteArraySet<String> clusters;

        private RemoteClusterResolver(Settings settings, ClusterSettings clusterSettings) {
            super(settings);
            this.clusters = new CopyOnWriteArraySet(RemoteClusterResolver.buildRemoteClustersDynamicConfig((Settings)settings).keySet());
            this.listenForUpdates(clusterSettings);
        }

        protected void updateRemoteCluster(String clusterAlias, List<String> addresses, String proxyAddress) {
            if (addresses.isEmpty()) {
                this.clusters.remove(clusterAlias);
            } else {
                this.clusters.add(clusterAlias);
            }
        }

        ResolvedIndices splitLocalAndRemoteIndexNames(String ... indices) {
            Map map = super.groupClusterIndices(this.clusters, indices, exists -> false);
            List local = (List)map.remove("");
            List<String> remote = map.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> (String)e.getKey() + ':' + v)).collect(Collectors.toList());
            return new ResolvedIndices(local == null ? Collections.emptyList() : local, remote);
        }
    }
}

