/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class AuditTrailService
implements AuditTrail {
    private final XPackLicenseState licenseState;
    private final List<AuditTrail> auditTrails;

    @Override
    public String name() {
        return "service";
    }

    public AuditTrailService(List<AuditTrail> auditTrails, XPackLicenseState licenseState) {
        this.auditTrails = Collections.unmodifiableList(auditTrails);
        this.licenseState = licenseState;
    }

    public List<AuditTrail> getAuditTrails() {
        return this.auditTrails;
    }

    @Override
    public void authenticationSuccess(String requestId, String realm, User user, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationSuccess(requestId, realm, user, request);
            }
        }
    }

    @Override
    public void authenticationSuccess(String requestId, String realm, User user, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationSuccess(requestId, realm, user, action, message);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String requestId, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.anonymousAccessDenied(requestId, action, message);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String requestId, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.anonymousAccessDenied(requestId, request);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, request);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, action, message);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, AuthenticationToken token, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, token, action, message);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, realm, token, action, message);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, AuthenticationToken token, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, token, request);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, String realm, AuthenticationToken token, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, realm, token, request);
            }
        }
    }

    @Override
    public void accessGranted(String requestId, Authentication authentication, String action, TransportMessage msg, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.accessGranted(requestId, authentication, action, msg, roleNames);
            }
        }
    }

    @Override
    public void accessDenied(String requestId, Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.accessDenied(requestId, authentication, action, message, roleNames);
            }
        }
    }

    @Override
    public void tamperedRequest(String requestId, RestRequest request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(requestId, request);
            }
        }
    }

    @Override
    public void tamperedRequest(String requestId, String action, TransportMessage message) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(requestId, action, message);
            }
        }
    }

    @Override
    public void tamperedRequest(String requestId, User user, String action, TransportMessage request) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(requestId, user, action, request);
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.connectionGranted(inetAddress, profile, rule);
            }
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.connectionDenied(inetAddress, profile, rule);
            }
        }
    }

    @Override
    public void runAsGranted(String requestId, Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsGranted(requestId, authentication, action, message, roleNames);
            }
        }
    }

    @Override
    public void runAsDenied(String requestId, Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsDenied(requestId, authentication, action, message, roleNames);
            }
        }
    }

    @Override
    public void runAsDenied(String requestId, Authentication authentication, RestRequest request, String[] roleNames) {
        if (this.licenseState.isAuditingAllowed()) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsDenied(requestId, authentication, request, roleNames);
            }
        }
    }
}

