/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.AuthorizationService;

public class TransportGetUserPrivilegesAction
extends HandledTransportAction<GetUserPrivilegesRequest, GetUserPrivilegesResponse> {
    private final ThreadPool threadPool;
    private final AuthorizationService authorizationService;

    @Inject
    public TransportGetUserPrivilegesAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthorizationService authorizationService) {
        super("cluster:admin/xpack/security/user/list_privileges", transportService, actionFilters, GetUserPrivilegesRequest::new);
        this.threadPool = threadPool;
        this.authorizationService = authorizationService;
    }

    protected void doExecute(Task task, GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        String username = request.username();
        User user = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext()).getUser();
        if (!user.principal().equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only list the privileges of their own account"));
            return;
        }
        this.authorizationService.roles(user, (ActionListener<Role>)ActionListener.wrap(role -> listener.onResponse((Object)this.buildResponseObject((Role)role)), arg_0 -> listener.onFailure(arg_0)));
    }

    GetUserPrivilegesResponse buildResponseObject(Role userRole) {
        this.logger.trace(() -> new ParameterizedMessage("List privileges for role [{}]", (Object)Strings.arrayToCommaDelimitedString((Object[])userRole.names())));
        TreeSet cluster = new TreeSet();
        HashSet<ConditionalClusterPrivilege> conditionalCluster = new HashSet<ConditionalClusterPrivilege>();
        for (Object tup : userRole.cluster().privileges()) {
            if (tup.v2() == null) {
                if (ClusterPrivilege.NONE.equals(tup.v1())) continue;
                cluster.addAll(((ClusterPrivilege)tup.v1()).name());
                continue;
            }
            conditionalCluster.add((ConditionalClusterPrivilege)tup.v2());
        }
        LinkedHashSet<GetUserPrivilegesResponse.Indices> indices = new LinkedHashSet<GetUserPrivilegesResponse.Indices>();
        for (Object group : userRole.indices()) {
            Set queries = group.getQuery() == null ? Collections.emptySet() : group.getQuery();
            Set fieldSecurity = group.getFieldPermissions().hasFieldLevelSecurity() ? group.getFieldPermissions().getFieldPermissionsDefinition().getFieldGrantExcludeGroups() : Collections.emptySet();
            indices.add(new GetUserPrivilegesResponse.Indices(Arrays.asList(group.indices()), (Collection)group.privilege().name(), fieldSecurity, queries));
        }
        LinkedHashSet<RoleDescriptor.ApplicationResourcePrivileges> application = new LinkedHashSet<RoleDescriptor.ApplicationResourcePrivileges>();
        for (String applicationName : userRole.application().getApplicationNames()) {
            for (ApplicationPrivilege privilege : userRole.application().getPrivileges(applicationName)) {
                Set resources = userRole.application().getResourcePatterns(privilege);
                if (resources.isEmpty()) {
                    this.logger.trace("No resources defined in application privilege {}", (Object)privilege);
                    continue;
                }
                application.add(RoleDescriptor.ApplicationResourcePrivileges.builder().application(applicationName).privileges((Collection)privilege.name()).resources((Collection)resources).build());
            }
        }
        Privilege runAsPrivilege = userRole.runAs().getPrivilege();
        Set runAs = Operations.isEmpty((Automaton)runAsPrivilege.getAutomaton()) ? Collections.emptySet() : runAsPrivilege.name();
        return new GetUserPrivilegesResponse(cluster, conditionalCluster, indices, application, runAs);
    }
}

