/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionResponse;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;
import org.elasticsearch.xpack.security.authc.saml.SamlLogoutRequestHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlRedirect;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.StatusResponseType;

public final class TransportSamlInvalidateSessionAction
extends HandledTransportAction<SamlInvalidateSessionRequest, SamlInvalidateSessionResponse> {
    private final TokenService tokenService;
    private final Realms realms;

    @Inject
    public TransportSamlInvalidateSessionAction(TransportService transportService, ActionFilters actionFilters, TokenService tokenService, Realms realms) {
        super("cluster:admin/xpack/security/saml/invalidate", transportService, actionFilters, SamlInvalidateSessionRequest::new);
        this.tokenService = tokenService;
        this.realms = realms;
    }

    protected void doExecute(Task task, SamlInvalidateSessionRequest request, ActionListener<SamlInvalidateSessionResponse> listener) {
        List<SamlRealm> realms = SamlRealm.findSamlRealms(this.realms, request.getRealmName(), request.getAssertionConsumerServiceURL());
        if (realms.isEmpty()) {
            listener.onFailure((Exception)((Object)SamlUtils.samlException("Cannot find any matching realm for [{}]", request)));
        } else if (realms.size() > 1) {
            listener.onFailure((Exception)((Object)SamlUtils.samlException("Found multiple matching realms [{}] for [{}]", realms, request)));
        } else {
            this.invalidateSession(realms.get(0), request, listener);
        }
    }

    private void invalidateSession(SamlRealm realm, SamlInvalidateSessionRequest request, ActionListener<SamlInvalidateSessionResponse> listener) {
        try {
            SamlLogoutRequestHandler.Result result = realm.getLogoutHandler().parseFromQueryString(request.getQueryString());
            this.findAndInvalidateTokens(realm, result, (ActionListener<Integer>)ActionListener.wrap(count -> listener.onResponse((Object)new SamlInvalidateSessionResponse(realm.name(), count.intValue(), this.buildLogoutResponseUrl(realm, result))), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (ElasticsearchSecurityException e) {
            this.logger.info("Failed to invalidate SAML session", (Throwable)e);
            listener.onFailure((Exception)((Object)e));
        }
    }

    private String buildLogoutResponseUrl(SamlRealm realm, SamlLogoutRequestHandler.Result result) {
        LogoutResponse response = realm.buildLogoutResponse(result.getRequestId());
        return new SamlRedirect((StatusResponseType)response, realm.getSigningConfiguration()).getRedirectUrl(result.getRelayState());
    }

    private void findAndInvalidateTokens(SamlRealm realm, SamlLogoutRequestHandler.Result result, ActionListener<Integer> listener) {
        Map<String, Object> tokenMetadata = realm.createTokenMetadata(result.getNameId(), result.getSession());
        if (!Strings.hasText((String)((String)tokenMetadata.get("saml_nameid_val")))) {
            this.logger.debug("Logout request [{}] has no NameID value, so cannot invalidate any sessions", (Object)result);
            listener.onResponse((Object)0);
            return;
        }
        this.tokenService.findActiveTokensForRealm(realm.name(), (ActionListener<Collection<Tuple<UserToken, String>>>)ActionListener.wrap(tokens -> {
            List<Tuple<UserToken, String>> sessionTokens = this.filterTokens((Collection<Tuple<UserToken, String>>)tokens, tokenMetadata);
            this.logger.debug("Found [{}] token pairs to invalidate for SAML metadata [{}]", (Object)sessionTokens.size(), (Object)tokenMetadata);
            if (sessionTokens.isEmpty()) {
                listener.onResponse((Object)0);
            } else {
                GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(collection -> listener.onResponse((Object)collection.size()), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), sessionTokens.size(), Collections.emptyList());
                sessionTokens.forEach(tuple -> this.invalidateTokenPair((Tuple<UserToken, String>)tuple, (ActionListener<Boolean>)groupedListener));
            }
        }, e -> listener.onFailure(e)));
    }

    private void invalidateTokenPair(Tuple<UserToken, String> tokenPair, ActionListener<Boolean> listener) {
        this.tokenService.invalidateRefreshToken((String)tokenPair.v2(), (ActionListener<Boolean>)ActionListener.wrap(ignore -> this.tokenService.invalidateAccessToken((UserToken)tokenPair.v1(), (ActionListener<Boolean>)ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
            this.logger.info("Failed to invalidate SAML access_token [{}] - {}", (Object)((UserToken)tokenPair.v1()).getId(), (Object)e.toString());
            listener.onFailure(e);
        })), arg_0 -> listener.onFailure(arg_0)));
    }

    private List<Tuple<UserToken, String>> filterTokens(Collection<Tuple<UserToken, String>> tokens, Map<String, Object> requiredMetadata) {
        return tokens.stream().filter(tup -> {
            Map<String, Object> actualMetadata = ((UserToken)tup.v1()).getMetadata();
            return requiredMetadata.entrySet().stream().allMatch(e -> Objects.equals(actualMetadata.get(e.getKey()), e.getValue()));
        }).collect(Collectors.toList());
    }
}

