/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;
import org.elasticsearch.xpack.security.authc.saml.SamlToken;

public final class TransportSamlAuthenticateAction
extends HandledTransportAction<SamlAuthenticateRequest, SamlAuthenticateResponse> {
    private final ThreadPool threadPool;
    private final AuthenticationService authenticationService;
    private final TokenService tokenService;

    @Inject
    public TransportSamlAuthenticateAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthenticationService authenticationService, TokenService tokenService) {
        super("cluster:admin/xpack/security/saml/authenticate", transportService, actionFilters, SamlAuthenticateRequest::new);
        this.threadPool = threadPool;
        this.authenticationService = authenticationService;
        this.tokenService = tokenService;
    }

    protected void doExecute(Task task, SamlAuthenticateRequest request, ActionListener<SamlAuthenticateResponse> listener) {
        SamlToken saml = new SamlToken(request.getSaml(), request.getValidRequestIds());
        this.logger.trace("Attempting to authenticate SamlToken [{}]", (Object)saml);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        Authentication originatingAuthentication = Authentication.getAuthentication((ThreadContext)threadContext);
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.authenticationService.authenticate("cluster:admin/xpack/security/saml/authenticate", (TransportMessage)request, saml, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                AuthenticationResult result = (AuthenticationResult)threadContext.getTransient(AuthenticationResult.THREAD_CONTEXT_KEY);
                if (result == null) {
                    listener.onFailure((Exception)new IllegalStateException("Cannot find AuthenticationResult on thread context"));
                    return;
                }
                Map tokenMeta = (Map)result.getMetadata().get("_xpack_saml_tokendata");
                this.tokenService.createUserToken((Authentication)authentication, originatingAuthentication, (ActionListener<Tuple<UserToken, String>>)ActionListener.wrap(tuple -> {
                    String tokenString = this.tokenService.getUserTokenString((UserToken)tuple.v1());
                    TimeValue expiresIn = this.tokenService.getExpirationDelay();
                    listener.onResponse((Object)new SamlAuthenticateResponse(authentication.getUser().principal(), tokenString, (String)tuple.v2(), expiresIn));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), tokenMeta, true);
            }, e -> {
                this.logger.debug(() -> new ParameterizedMessage("SamlToken [{}] could not be authenticated", (Object)saml), (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }
}

