/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.interceptor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;

abstract class FieldAndDocumentLevelSecurityRequestInterceptor<Request extends IndicesRequest>
implements RequestInterceptor<Request> {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final Logger logger;

    FieldAndDocumentLevelSecurityRequestInterceptor(ThreadContext threadContext, XPackLicenseState licenseState) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
        this.logger = LogManager.getLogger(this.getClass());
    }

    @Override
    public void intercept(Request request, Authentication authentication, Role userPermissions, String action) {
        if (this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
            for (String index : request.indices()) {
                IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
                if (indexAccessControl != null) {
                    boolean documentLevelSecurityEnabled;
                    boolean fieldLevelSecurityEnabled = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                    boolean bl = documentLevelSecurityEnabled = indexAccessControl.getQueries() != null;
                    if (fieldLevelSecurityEnabled || documentLevelSecurityEnabled) {
                        if (fieldLevelSecurityEnabled || documentLevelSecurityEnabled) {
                            this.logger.trace("intercepted request for index [{}] with field level access controls [{}] document level access controls [{}]. disabling conflicting features", (Object)index, (Object)fieldLevelSecurityEnabled, (Object)documentLevelSecurityEnabled);
                        }
                        this.disableFeatures(request, fieldLevelSecurityEnabled, documentLevelSecurityEnabled);
                        return;
                    }
                }
                this.logger.trace("intercepted request for index [{}] without field or document level access controls", (Object)index);
            }
        }
    }

    protected abstract void disableFeatures(Request var1, boolean var2, boolean var3);
}

