/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LatLonShapeQuery;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.Rectangle2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class LatLonShapeBoundingBoxQuery
extends LatLonShapeQuery {
    final Rectangle2D rectangle2D;

    public LatLonShapeBoundingBoxQuery(String field, LatLonShape.QueryRelation queryRelation, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, queryRelation);
        Rectangle rectangle = new Rectangle(minLat, maxLat, minLon, maxLon);
        this.rectangle2D = Rectangle2D.create(rectangle);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        return this.rectangle2D.relateRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
    }

    @Override
    protected boolean queryMatches(byte[] t) {
        long a = NumericUtils.sortableBytesToLong((byte[])t, (int)32);
        long b = NumericUtils.sortableBytesToLong((byte[])t, (int)40);
        long c = NumericUtils.sortableBytesToLong((byte[])t, (int)48);
        int aX = (int)(a >>> 32 & 0xFFFFFFFFL);
        int bX = (int)(b >>> 32 & 0xFFFFFFFFL);
        int cX = (int)(c >>> 32 & 0xFFFFFFFFL);
        int aY = (int)(a & 0xFFFFFFFFL);
        int bY = (int)(b & 0xFFFFFFFFL);
        int cY = (int)(c & 0xFFFFFFFFL);
        if (this.queryRelation == LatLonShape.QueryRelation.WITHIN) {
            return this.rectangle2D.containsTriangle(aX, aY, bX, bY, cX, cY);
        }
        return this.rectangle2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(((Object)((Object)this)).getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle2D.equals(((LatLonShapeBoundingBoxQuery)((Object)o)).rectangle2D);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.rectangle2D.hashCode();
        return hash;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle2D.toString());
        return sb.toString();
    }
}

