/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade.rest;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.protocol.xpack.migration.IndexUpgradeInfoRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeInfoAction;

public class RestIndexUpgradeInfoAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestIndexUpgradeInfoAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    public RestIndexUpgradeInfoAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "_migration/assistance", (RestHandler)this, RestRequest.Method.GET, "/_xpack/migration/assistance", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "_migration/assistance/{index}", (RestHandler)this, RestRequest.Method.GET, "/_xpack/migration/assistance/{index}", deprecationLogger);
    }

    public String getName() {
        return "migration_assistance";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method().equals((Object)RestRequest.Method.GET)) {
            return this.handleGet(request, client);
        }
        throw new IllegalArgumentException("illegal method [" + request.method() + "] for request [" + request.path() + "]");
    }

    private BaseRestHandler.RestChannelConsumer handleGet(RestRequest request, NodeClient client) {
        IndexUpgradeInfoRequest infoRequest = new IndexUpgradeInfoRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        infoRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)infoRequest.indicesOptions()));
        return channel -> client.execute((Action)IndexUpgradeInfoAction.INSTANCE, (ActionRequest)infoRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

