/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.protocol.xpack.migration.UpgradeActionRequired;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.upgrade.IndexUpgradeCheck;

public class IndexUpgradeService {
    private static final Logger logger = LogManager.getLogger(IndexUpgradeService.class);
    private final List<IndexUpgradeCheck> upgradeChecks;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public IndexUpgradeService(List<IndexUpgradeCheck> upgradeChecks) {
        this.upgradeChecks = upgradeChecks;
        this.indexNameExpressionResolver = new IndexNameExpressionResolver();
    }

    public Map<String, UpgradeActionRequired> upgradeInfo(String[] indices, IndicesOptions options, ClusterState state) {
        HashMap<String, UpgradeActionRequired> results = new HashMap<String, UpgradeActionRequired>();
        String[] concreteIndexNames = this.indexNameExpressionResolver.concreteIndexNames(state, options, indices);
        MetaData metaData = state.getMetaData();
        for (String index : concreteIndexNames) {
            IndexMetaData indexMetaData = metaData.index(index);
            UpgradeActionRequired upgradeActionRequired = this.upgradeInfo(indexMetaData, index);
            if (upgradeActionRequired == null) continue;
            results.put(index, upgradeActionRequired);
        }
        return results;
    }

    private UpgradeActionRequired upgradeInfo(IndexMetaData indexMetaData, String index) {
        block5: for (IndexUpgradeCheck check : this.upgradeChecks) {
            UpgradeActionRequired upgradeActionRequired = check.actionRequired(indexMetaData);
            logger.trace("[{}] check [{}] returned [{}]", (Object)index, (Object)check.getName(), (Object)upgradeActionRequired);
            switch (upgradeActionRequired) {
                case UPGRADE: 
                case REINDEX: {
                    return upgradeActionRequired;
                }
                case UP_TO_DATE: {
                    return null;
                }
                case NOT_APPLICABLE: {
                    continue block5;
                }
            }
            throw new IllegalStateException("unknown upgrade action " + upgradeActionRequired + " for the index " + index);
        }
        if (indexMetaData.getCreationVersion().before(Version.V_6_0_0)) {
            return UpgradeActionRequired.REINDEX;
        }
        return null;
    }

    public void upgrade(TaskId task, String index, ClusterState state, ActionListener<BulkByScrollResponse> listener) {
        IndexMetaData indexMetaData = state.metaData().index(index);
        if (indexMetaData == null) {
            throw new IndexNotFoundException(index);
        }
        block6: for (IndexUpgradeCheck check : this.upgradeChecks) {
            UpgradeActionRequired upgradeActionRequired = check.actionRequired(indexMetaData);
            switch (upgradeActionRequired) {
                case UPGRADE: {
                    check.upgrade(task, indexMetaData, state, listener);
                    return;
                }
                case REINDEX: {
                    throw new IllegalStateException("Index [" + index + "] cannot be upgraded, it should be reindex instead");
                }
                case UP_TO_DATE: {
                    throw new IllegalStateException("Index [" + index + "] cannot be upgraded, it is up to date");
                }
                case NOT_APPLICABLE: {
                    continue block6;
                }
            }
            throw new IllegalStateException("unknown upgrade action [" + upgradeActionRequired + "] for the index [" + index + "]");
        }
        throw new IllegalStateException("Index [" + index + "] cannot be upgraded");
    }
}

