/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.ClusterStateActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.core.indexlifecycle.TerminalPolicyStep;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleRunner;
import org.elasticsearch.xpack.indexlifecycle.MoveToErrorStepUpdateTask;
import org.elasticsearch.xpack.indexlifecycle.PolicyStepsRegistry;

public class ExecuteStepsUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(ExecuteStepsUpdateTask.class);
    private final String policy;
    private final Index index;
    private final Step startStep;
    private final PolicyStepsRegistry policyStepsRegistry;
    private final IndexLifecycleRunner lifecycleRunner;
    private LongSupplier nowSupplier;
    private Step.StepKey nextStepKey = null;

    public ExecuteStepsUpdateTask(String policy, Index index, Step startStep, PolicyStepsRegistry policyStepsRegistry, IndexLifecycleRunner lifecycleRunner, LongSupplier nowSupplier) {
        this.policy = policy;
        this.index = index;
        this.startStep = startStep;
        this.policyStepsRegistry = policyStepsRegistry;
        this.nowSupplier = nowSupplier;
        this.lifecycleRunner = lifecycleRunner;
    }

    String getPolicy() {
        return this.policy;
    }

    Index getIndex() {
        return this.index;
    }

    Step getStartStep() {
        return this.startStep;
    }

    Step.StepKey getNextStepKey() {
        return this.nextStepKey;
    }

    public ClusterState execute(ClusterState currentState) throws IOException {
        Step currentStep = this.startStep;
        IndexMetaData indexMetaData = currentState.metaData().index(this.index);
        if (indexMetaData == null) {
            logger.debug("lifecycle for index [{}] executed but index no longer exists", (Object)this.index.getName());
            return currentState;
        }
        Step registeredCurrentStep = IndexLifecycleRunner.getCurrentStep(this.policyStepsRegistry, this.policy, indexMetaData, LifecycleExecutionState.fromIndexMetadata((IndexMetaData)indexMetaData));
        if (currentStep.equals((Object)registeredCurrentStep)) {
            ClusterState state = currentState;
            while (currentStep instanceof ClusterStateActionStep || currentStep instanceof ClusterStateWaitStep) {
                this.nextStepKey = currentStep.getNextStepKey();
                if (currentStep instanceof ClusterStateActionStep) {
                    logger.trace("[{}] performing cluster state action ({}) [{}], next: [{}]", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey(), (Object)currentStep.getNextStepKey());
                    try {
                        state = ((ClusterStateActionStep)currentStep).performAction(this.index, state);
                    }
                    catch (Exception exception) {
                        return this.moveToErrorStep(state, currentStep.getKey(), exception);
                    }
                    if (currentStep.getNextStepKey() == null) {
                        return state;
                    }
                    state = IndexLifecycleRunner.moveClusterStateToNextStep(this.index, state, currentStep.getKey(), currentStep.getNextStepKey(), this.nowSupplier, false);
                } else {
                    ClusterStateWaitStep.Result result;
                    logger.trace("[{}] waiting for cluster state step condition ({}) [{}], next: [{}]", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey(), (Object)currentStep.getNextStepKey());
                    try {
                        result = ((ClusterStateWaitStep)currentStep).isConditionMet(this.index, state);
                    }
                    catch (Exception exception) {
                        return this.moveToErrorStep(state, currentStep.getKey(), exception);
                    }
                    if (result.isComplete()) {
                        logger.trace("[{}] cluster state step condition met successfully ({}) [{}], moving to next step {}", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey(), (Object)currentStep.getNextStepKey());
                        if (currentStep.getNextStepKey() == null) {
                            return state;
                        }
                        state = IndexLifecycleRunner.moveClusterStateToNextStep(this.index, state, currentStep.getKey(), currentStep.getNextStepKey(), this.nowSupplier, false);
                    } else {
                        logger.trace("[{}] condition not met ({}) [{}], returning existing state", (Object)this.index.getName(), (Object)currentStep.getClass().getSimpleName(), (Object)currentStep.getKey());
                        this.nextStepKey = null;
                        ToXContentObject stepInfo = result.getInfomationContext();
                        if (stepInfo == null) {
                            return state;
                        }
                        return IndexLifecycleRunner.addStepInfoToClusterState(this.index, state, stepInfo);
                    }
                }
                if (!currentStep.getKey().getPhase().equals(currentStep.getNextStepKey().getPhase())) {
                    return state;
                }
                currentStep = this.policyStepsRegistry.getStep(indexMetaData, currentStep.getNextStepKey());
            }
            return state;
        }
        return currentState;
    }

    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        if (!oldState.equals(newState)) {
            IndexMetaData indexMetaData = newState.metaData().index(this.index);
            if (this.nextStepKey != null && this.nextStepKey != TerminalPolicyStep.KEY && indexMetaData != null) {
                logger.trace("[{}] step sequence starting with {} has completed, running next step {} if it is an async action", (Object)this.index.getName(), (Object)this.startStep.getKey(), (Object)this.nextStepKey);
                this.lifecycleRunner.maybeRunAsyncAction(newState, indexMetaData, this.policy, this.nextStepKey);
            }
        }
    }

    public void onFailure(String source, Exception e) {
        throw new ElasticsearchException("policy [" + this.policy + "] for index [" + this.index.getName() + "] failed on step [" + this.startStep.getKey() + "].", (Throwable)e, new Object[0]);
    }

    private ClusterState moveToErrorStep(ClusterState state, Step.StepKey currentStepKey, Exception cause) throws IOException {
        logger.error("policy [{}] for index [{}] failed on cluster state step [{}]. Moving to ERROR step", (Object)this.policy, (Object)this.index.getName(), (Object)currentStepKey);
        MoveToErrorStepUpdateTask moveToErrorStepUpdateTask = new MoveToErrorStepUpdateTask(this.index, this.policy, currentStepKey, cause, this.nowSupplier);
        return moveToErrorStepUpdateTask.execute(state);
    }
}

