/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.stats;

import java.util.Locale;
import org.elasticsearch.xpack.sql.proto.Mode;

public enum QueryMetric {
    CANVAS,
    CLI,
    JDBC,
    ODBC,
    REST;


    public static QueryMetric fromString(String metric) {
        try {
            return QueryMetric.valueOf(metric.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            return REST;
        }
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static QueryMetric from(Mode mode, String clientId) {
        return QueryMetric.fromString(mode == Mode.PLAIN ? clientId : mode.toString());
    }
}

