/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.joda.time.DateTimeZone;

public class GroupByDateHistogram
extends GroupByKey {
    private final long interval;
    private final TimeZone timeZone;

    public GroupByDateHistogram(String id, String fieldName, long interval, TimeZone timeZone) {
        this(id, fieldName, null, null, interval, timeZone);
    }

    public GroupByDateHistogram(String id, ScriptTemplate script, long interval, TimeZone timeZone) {
        this(id, null, script, null, interval, timeZone);
    }

    private GroupByDateHistogram(String id, String fieldName, ScriptTemplate script, Sort.Direction direction, long interval, TimeZone timeZone) {
        super(id, fieldName, script, direction);
        this.interval = interval;
        this.timeZone = timeZone;
    }

    @Override
    protected CompositeValuesSourceBuilder<?> createSourceBuilder() {
        return new DateHistogramValuesSourceBuilder(this.id()).interval(this.interval).timeZone(DateTimeZone.forTimeZone((TimeZone)this.timeZone));
    }

    @Override
    protected GroupByKey copy(String id, String fieldName, ScriptTemplate script, Sort.Direction direction) {
        return new GroupByDateHistogram(id, fieldName, script, direction, this.interval, this.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GroupByDateHistogram other = (GroupByDateHistogram)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.timeZone, other.timeZone);
        }
        return false;
    }
}

