/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.InsertFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class InsertFunctionPipe
extends Pipe {
    private final Pipe source;
    private final Pipe start;
    private final Pipe length;
    private final Pipe replacement;

    public InsertFunctionPipe(Location location, Expression expression, Pipe source, Pipe start, Pipe length, Pipe replacement) {
        super(location, expression, Arrays.asList(source, start, length, replacement));
        this.source = source;
        this.start = start;
        this.length = length;
        this.replacement = replacement;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        if (newChildren.size() != 4) {
            throw new IllegalArgumentException("expected [4] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newSource = this.source.resolveAttributes(resolver);
        Pipe newStart = this.start.resolveAttributes(resolver);
        Pipe newLength = this.length.resolveAttributes(resolver);
        Pipe newReplacement = this.replacement.resolveAttributes(resolver);
        if (newSource == this.source && newStart == this.start && newLength == this.length && newReplacement == this.replacement) {
            return this;
        }
        return this.replaceChildren(newSource, newStart, newLength, newReplacement);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.source.supportedByAggsOnlyQuery() && this.start.supportedByAggsOnlyQuery() && this.length.supportedByAggsOnlyQuery() && this.replacement.supportedByAggsOnlyQuery();
    }

    @Override
    public boolean resolved() {
        return this.source.resolved() && this.start.resolved() && this.length.resolved() && this.replacement.resolved();
    }

    protected Pipe replaceChildren(Pipe newSource, Pipe newStart, Pipe newLength, Pipe newReplacement) {
        return new InsertFunctionPipe(this.location(), this.expression(), newSource, newStart, newLength, newReplacement);
    }

    @Override
    public final void collectFields(SqlSourceBuilder sourceBuilder) {
        this.source.collectFields(sourceBuilder);
        this.start.collectFields(sourceBuilder);
        this.length.collectFields(sourceBuilder);
        this.replacement.collectFields(sourceBuilder);
    }

    @Override
    protected NodeInfo<InsertFunctionPipe> info() {
        return NodeInfo.create(this, InsertFunctionPipe::new, this.expression(), this.source, this.start, this.length, this.replacement);
    }

    @Override
    public InsertFunctionProcessor asProcessor() {
        return new InsertFunctionProcessor(this.source.asProcessor(), this.start.asProcessor(), this.length.asProcessor(), this.replacement.asProcessor());
    }

    public Pipe source() {
        return this.source;
    }

    public Pipe start() {
        return this.start;
    }

    public Pipe length() {
        return this.length;
    }

    public Pipe replacement() {
        return this.replacement;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.start, this.length, this.replacement);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsertFunctionPipe other = (InsertFunctionPipe)obj;
        return Objects.equals(this.source, other.source) && Objects.equals(this.start, other.start) && Objects.equals(this.length, other.length) && Objects.equals(this.replacement, other.replacement);
    }
}

