/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NonIsoDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.StringUtils;

abstract class NonIsoDateTimeFunction
extends BaseDateTimeFunction {
    private final NonIsoDateTimeProcessor.NonIsoDateTimeExtractor extractor;

    NonIsoDateTimeFunction(Location location, Expression field, TimeZone timeZone, NonIsoDateTimeProcessor.NonIsoDateTimeExtractor extractor) {
        super(location, field, timeZone);
        this.extractor = extractor;
    }

    @Override
    protected Object doFold(ZonedDateTime dateTime) {
        return this.extractor.extract(dateTime);
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.formatTemplate(String.format(Locale.ROOT, "{sql}.%s(doc[{}].value, {})", StringUtils.underscoreToLowerCamelCase(this.extractor.name()))), ParamsBuilder.paramsBuilder().variable(field.name()).variable(this.timeZone().getID()).build(), this.dataType());
    }

    @Override
    protected Processor makeProcessor() {
        return new NonIsoDateTimeProcessor(this.extractor, this.timeZone());
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }
}

