/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.NamedDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.StringUtils;

abstract class NamedDateTimeFunction
extends BaseDateTimeFunction {
    private final NamedDateTimeProcessor.NameExtractor nameExtractor;

    NamedDateTimeFunction(Location location, Expression field, TimeZone timeZone, NamedDateTimeProcessor.NameExtractor nameExtractor) {
        super(location, field, timeZone);
        this.nameExtractor = nameExtractor;
    }

    @Override
    protected Object doFold(ZonedDateTime dateTime) {
        return this.nameExtractor.extract(dateTime);
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.formatTemplate(String.format(Locale.ROOT, "{sql}.%s(doc[{}].value, {})", StringUtils.underscoreToLowerCamelCase(this.nameExtractor.name()))), ParamsBuilder.paramsBuilder().variable(field.name()).variable(this.timeZone().getID()).build(), this.dataType());
    }

    @Override
    protected Processor makeProcessor() {
        return new NamedDateTimeProcessor(this.nameExtractor, this.timeZone());
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }
}

