/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.capabilities.Unresolvable;
import org.elasticsearch.xpack.sql.capabilities.UnresolvedException;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.StringUtils;

public class UnresolvedFunction
extends Function
implements Unresolvable {
    private final String name;
    private final String unresolvedMsg;
    private final ResolutionType resolutionType;
    private final boolean analyzed;

    public UnresolvedFunction(Location location, String name, ResolutionType resolutionType, List<Expression> children) {
        this(location, name, resolutionType, children, false, null);
    }

    UnresolvedFunction(Location location, String name, ResolutionType resolutionType, List<Expression> children, boolean analyzed, String unresolvedMessage) {
        super(location, children);
        this.name = name;
        this.resolutionType = resolutionType;
        this.analyzed = analyzed;
        this.unresolvedMsg = unresolvedMessage == null ? "Unknown " + resolutionType.type() + " [" + name + "]" : unresolvedMessage;
    }

    @Override
    protected NodeInfo<UnresolvedFunction> info() {
        return NodeInfo.create(this, UnresolvedFunction::new, this.name, this.resolutionType, this.children(), this.analyzed, this.unresolvedMsg);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new UnresolvedFunction(this.location(), this.name, this.resolutionType, newChildren, this.analyzed, this.unresolvedMsg);
    }

    public UnresolvedFunction withMessage(String message) {
        return new UnresolvedFunction(this.location(), this.name(), this.resolutionType, this.children(), true, message);
    }

    public UnresolvedFunction preprocessStar() {
        return this.resolutionType.preprocessStar(this);
    }

    public Function buildResolved(Configuration configuration, FunctionDefinition def) {
        return this.resolutionType.buildResolved(this, configuration, def);
    }

    public UnresolvedFunction missing(String normalizedName, Iterable<FunctionDefinition> alternatives) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (FunctionDefinition def : alternatives) {
            if (!this.resolutionType.isValidAlternative(def)) continue;
            names.add(def.name());
            names.addAll(def.aliases());
        }
        List<String> matches = StringUtils.findSimilar(normalizedName, names);
        if (matches.isEmpty()) {
            return this;
        }
        String matchesMessage = matches.size() == 1 ? "[" + matches.get(0) + "]" : "any of " + matches;
        return this.withMessage("Unknown " + this.resolutionType.type() + " [" + this.name + "], did you mean " + matchesMessage + "?");
    }

    @Override
    public boolean resolved() {
        return false;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String functionName() {
        return this.name;
    }

    ResolutionType resolutionType() {
        return this.resolutionType;
    }

    public boolean analyzed() {
        return this.analyzed;
    }

    @Override
    public DataType dataType() {
        throw new UnresolvedException("dataType", (Object)this);
    }

    @Override
    public boolean nullable() {
        throw new UnresolvedException("nullable", (Object)this);
    }

    @Override
    public Attribute toAttribute() {
        throw new UnresolvedException("attribute", (Object)this);
    }

    @Override
    public ScriptTemplate asScript() {
        throw new UnresolvedException("script", (Object)this);
    }

    @Override
    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    @Override
    public String toString() {
        return "?" + this.functionName() + this.functionArgs();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnresolvedFunction other = (UnresolvedFunction)obj;
        return this.name.equals(other.name) && this.resolutionType.equals((Object)other.resolutionType) && this.children().equals(other.children()) && this.analyzed == other.analyzed && Objects.equals(this.unresolvedMsg, other.unresolvedMsg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.resolutionType, this.children(), this.analyzed, this.unresolvedMsg});
    }

    public static enum ResolutionType {
        STANDARD{

            @Override
            public UnresolvedFunction preprocessStar(UnresolvedFunction uf) {
                if (uf.name.toUpperCase(Locale.ROOT).equals("COUNT")) {
                    return new UnresolvedFunction(uf.location(), uf.name(), uf.resolutionType, Collections.singletonList(Literal.of(uf.arguments().get(0).location(), (Object)1)));
                }
                return uf;
            }

            @Override
            public Function buildResolved(UnresolvedFunction uf, Configuration cfg, FunctionDefinition def) {
                return def.builder().build(uf, false, cfg);
            }

            @Override
            protected boolean isValidAlternative(FunctionDefinition def) {
                return true;
            }

            @Override
            protected String type() {
                return "function";
            }
        }
        ,
        DISTINCT{

            @Override
            public UnresolvedFunction preprocessStar(UnresolvedFunction uf) {
                return uf.withMessage("* is not valid with DISTINCT");
            }

            @Override
            public Function buildResolved(UnresolvedFunction uf, Configuration cfg, FunctionDefinition def) {
                return def.builder().build(uf, true, cfg);
            }

            @Override
            protected boolean isValidAlternative(FunctionDefinition def) {
                return false;
            }

            @Override
            protected String type() {
                return "function";
            }
        }
        ,
        EXTRACT{

            @Override
            public UnresolvedFunction preprocessStar(UnresolvedFunction uf) {
                return uf.withMessage("Can't extract from *");
            }

            @Override
            public Function buildResolved(UnresolvedFunction uf, Configuration cfg, FunctionDefinition def) {
                if (def.extractViable()) {
                    return def.builder().build(uf, false, cfg);
                }
                return uf.withMessage("Invalid datetime field [" + uf.name() + "]. Use any datetime function.");
            }

            @Override
            protected boolean isValidAlternative(FunctionDefinition def) {
                return def.extractViable();
            }

            @Override
            protected String type() {
                return "datetime field";
            }
        };


        protected abstract UnresolvedFunction preprocessStar(UnresolvedFunction var1);

        protected abstract Function buildResolved(UnresolvedFunction var1, Configuration var2, FunctionDefinition var3);

        protected abstract boolean isValidAlternative(FunctionDefinition var1);

        protected abstract String type();
    }
}

